/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.maven.Messages;
import org.eclipse.buckminster.maven.internal.GroupAndArtifact;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProvider
extends Provider {
    public static final String BM_MAVEN_PROVIDER_NS = "http://www.eclipse.org/buckminster/MavenProvider-1.0";
    public static final String BM_MAVEN_PROVIDER_PREFIX = "mp";
    public static final String ELEM_MAPPINGS = "mappings";
    public static final String ELEM_RULE = "rule";
    private final Map<String, MapEntry> m_mappings;
    private final List<BidirectionalTransformer> m_rules;

    public static MapEntry getDefaultGroupAndArtifact(String name) {
        int dotIdx = name.lastIndexOf(47);
        return dotIdx > 0 ? new MapEntry(name, name.substring(0, dotIdx), name.substring(dotIdx + 1), null) : new MapEntry(name, name, name, null);
    }

    public static String getDefaultName(String groupId, String artifactId) {
        if (groupId.equals(artifactId)) {
            int colonIdx = artifactId.indexOf(58);
            if (colonIdx < 0) {
                return artifactId;
            }
            groupId = artifactId.substring(0, colonIdx);
            artifactId = artifactId.substring(colonIdx + 1);
        }
        return String.valueOf(groupId) + '/' + artifactId;
    }

    public MavenProvider(SearchPath searchPath, String remoteReaderType, String[] componentTypes, VersionConverterDesc versionConverterDesc, Format uri, Filter resolutionFilter, boolean mutable, boolean source, Documentation documentation, Map<String, MapEntry> mappings, List<BidirectionalTransformer> rules) {
        super(searchPath, remoteReaderType, componentTypes, versionConverterDesc, uri, null, null, resolutionFilter, mutable, source, null, documentation);
        if (mappings == null) {
            mappings = Collections.emptyMap();
        }
        if (rules == null) {
            rules = Collections.emptyList();
        }
        this.m_mappings = mappings;
        this.m_rules = rules;
    }

    public void addPrefixMappings(HashMap<String, String> prefixMappings) {
        super.addPrefixMappings(prefixMappings);
        prefixMappings.put(BM_MAVEN_PROVIDER_PREFIX, BM_MAVEN_PROVIDER_NS);
    }

    public IVersionConverter getVersionConverter() throws CoreException {
        return CorePlugin.getDefault().getVersionConverter("tag");
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        attrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi:type", "CDATA", "mp:MavenProvider");
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        super.emitElements(handler, namespace, prefix);
        if (this.m_mappings.size() == 0 && this.m_rules.size() == 0) {
            return;
        }
        String qName = Utils.makeQualifiedName((String)BM_MAVEN_PROVIDER_PREFIX, (String)ELEM_MAPPINGS);
        handler.startElement(BM_MAVEN_PROVIDER_NS, ELEM_MAPPINGS, qName, ISaxableElement.EMPTY_ATTRIBUTES);
        for (MapEntry mapping : this.m_mappings.values()) {
            mapping.toSax(handler, BM_MAVEN_PROVIDER_NS, BM_MAVEN_PROVIDER_PREFIX, mapping.getDefaultTag());
        }
        for (BidirectionalTransformer rule : this.m_rules) {
            rule.toSax(handler, BM_MAVEN_PROVIDER_NS, BM_MAVEN_PROVIDER_PREFIX, ELEM_RULE);
        }
        handler.endElement(BM_MAVEN_PROVIDER_NS, ELEM_MAPPINGS, qName);
    }

    String getComponentName(String groupId, String artifactId) throws CoreException {
        for (MapEntry me : this.m_mappings.values()) {
            if (me.isMatchFor(groupId, artifactId)) {
                return me.getName();
            }
            List<GroupAndArtifact> aliases = me.getAliases();
            int idx = aliases.size();
            while (--idx >= 0) {
                GroupAndArtifact alias = aliases.get(idx);
                if (!alias.isMatchFor(groupId, artifactId)) continue;
                return me.getName();
            }
        }
        if (this.m_rules.size() > 0) {
            String compiled = String.valueOf(groupId) + '/' + artifactId;
            for (BidirectionalTransformer rule : this.m_rules) {
                String transformed = rule.transformTo(compiled);
                if (transformed == null) continue;
                return transformed;
            }
        }
        return MavenProvider.getDefaultName(groupId, artifactId);
    }

    MapEntry getGroupAndArtifact(String name) throws CoreException {
        MapEntry entry = this.m_mappings.get(name);
        if (entry != null) {
            return entry;
        }
        String transformed = null;
        for (BidirectionalTransformer rule : this.m_rules) {
            transformed = rule.transformFrom(name);
            if (transformed != null) break;
        }
        if (transformed == null) {
            return MavenProvider.getDefaultGroupAndArtifact(name);
        }
        int slashPos = transformed.indexOf(47);
        if (slashPos < 0) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.the_result_of_applying_a_match_rule_had_no_separator_slash_0, (Object)transformed), (Object[])new Object[0]);
        }
        return new MapEntry(name, transformed.substring(0, slashPos), transformed.substring(slashPos + 1), null);
    }
}

