/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.reader.URLCatalogReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.maven.internal.ILocationResolver;
import org.eclipse.buckminster.maven.internal.LocalCache;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.maven.internal.MavenComponentType;
import org.eclipse.buckminster.maven.internal.MavenProvider;
import org.eclipse.buckminster.maven.internal.MavenReader;
import org.eclipse.buckminster.maven.internal.MavenVersionFinder;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.provisional.p2.core.Version;

public class MavenReaderType
extends URLCatalogReaderType {
    private final LocalCache m_localCache = new LocalCache(this.getLocalRepoPath());

    static void appendMavenVersionName(StringBuilder bld, VersionMatch vm) throws CoreException {
        Date timestamp;
        Version version;
        int vnSplit;
        String artifactInfo = vm.getArtifactInfo();
        if (artifactInfo != null && (vnSplit = artifactInfo.indexOf(47)) >= 0) {
            bld.append(artifactInfo, vnSplit + 1, artifactInfo.length());
            return;
        }
        VersionSelector vs = vm.getBranchOrTag();
        if (vs != null && vs.getType() == 0) {
            bld.append(vs.getName());
            bld.append('-');
        }
        if ((version = vm.getVersion()) != null) {
            bld.append(VersionHelper.getOriginal((Version)version));
        }
        if ((timestamp = vm.getTimestamp()) != null) {
            if (version != null) {
                bld.append('-');
            }
            bld.append(VersionHelper.toTimestampString((Date)timestamp));
        }
    }

    static URL createURL(URI repoURI, String path) throws CoreException {
        try {
            return new URI(repoURI.getScheme(), repoURI.getAuthority(), path, null, null).toURL();
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    static MapEntry getGroupAndArtifact(Provider provider, ComponentRequest request) throws CoreException {
        String name = request.getName();
        return provider instanceof MavenProvider ? ((MavenProvider)provider).getGroupAndArtifact(name) : MavenProvider.getDefaultGroupAndArtifact(name);
    }

    public IPath getInstallLocation(Resolution resolution, MaterializationContext context) throws CoreException {
        MapEntry ga = MavenReaderType.getGroupAndArtifact(resolution.getProvider(), resolution.getRequest());
        VersionMatch vs = resolution.getVersionMatch();
        StringBuilder pbld = new StringBuilder();
        this.appendFolder(pbld, this.getMaterializationFolder());
        this.appendArtifactFolder(pbld, ga, vs);
        return Path.fromPortableString((String)pbld.toString());
    }

    public IPath getLeafArtifact(Resolution resolution, MaterializationContext context) throws CoreException {
        MapEntry ga = MavenReaderType.getGroupAndArtifact(resolution.getProvider(), resolution.getRequest());
        VersionMatch vs = resolution.getVersionMatch();
        StringBuilder pbld = new StringBuilder();
        this.appendFileName(pbld, ga.getArtifactId(), vs, null);
        return Path.fromPortableString((String)pbld.toString());
    }

    public IPath getLocalRepoPath() {
        return this.getDefaultLocalRepoPath();
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new MavenReader(this, providerMatch);
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new MavenVersionFinder(this, provider, ctype, nodeQuery);
    }

    void appendArtifactFolder(StringBuilder pbld, MapEntry mapEntry, VersionMatch vs) throws CoreException {
        this.appendFolder(pbld, mapEntry.getGroupId());
        this.appendFolder(pbld, "jars");
    }

    void appendFileName(StringBuilder bld, String artifactID, VersionMatch vm, String extension) throws CoreException {
        String artifactInfo = vm.getArtifactInfo();
        if (extension == null && artifactInfo != null) {
            int vnSplit = artifactInfo.indexOf(47);
            if (vnSplit >= 0) {
                bld.append(artifactInfo, 0, vnSplit);
                return;
            }
            extension = artifactInfo;
        }
        bld.append(artifactID);
        bld.append('-');
        MavenReaderType.appendMavenVersionName(bld, vm);
        bld.append(extension);
    }

    void appendFolder(StringBuilder pbld, String folder) {
        pbld.append(folder);
        if (!folder.endsWith("/")) {
            pbld.append('/');
        }
    }

    void appendPathToArtifact(StringBuilder pbld, MapEntry mapEntry, VersionMatch vs) throws CoreException {
        this.appendArtifactFolder(pbld, mapEntry, vs);
        this.appendFileName(pbld, mapEntry.getArtifactId(), vs, null);
    }

    void appendPathToPom(StringBuilder pbld, MapEntry mapEntry, VersionMatch vs) throws CoreException {
        this.appendPomFolder(pbld, mapEntry, vs);
        this.appendFileName(pbld, mapEntry.getArtifactId(), vs, ".pom");
    }

    void appendPomFolder(StringBuilder pbld, MapEntry mapEntry, VersionMatch vs) throws CoreException {
        this.appendFolder(pbld, mapEntry.getGroupId());
        this.appendFolder(pbld, "poms");
    }

    VersionMatch createVersionMatch(ILocationResolver resolver, MapEntry mapEntry, String versionStr) throws CoreException {
        return MavenComponentType.createVersionMatch(versionStr, null);
    }

    IPath getArtifactPath(MapEntry mapEntry, VersionMatch vs) throws CoreException {
        StringBuilder pbld = new StringBuilder();
        this.appendPathToArtifact(pbld, mapEntry, vs);
        return new Path(pbld.toString());
    }

    URL getArtifactURL(URI repoURI, MapEntry mapEntry, VersionMatch vs) throws CoreException {
        StringBuilder pbld = new StringBuilder();
        this.appendFolder(pbld, repoURI.getPath());
        this.appendPathToArtifact(pbld, mapEntry, vs);
        return MavenReaderType.createURL(repoURI, pbld.toString());
    }

    IPath getDefaultLocalRepoPath() {
        return new Path(System.getProperty("user.home")).append(".maven").append("cache");
    }

    LocalCache getLocalCache() {
        return this.m_localCache;
    }

    String getMaterializationFolder() {
        return "maven";
    }

    IPath getPomPath(MapEntry mapEntry, VersionMatch vs) throws CoreException {
        StringBuilder pbld = new StringBuilder();
        this.appendPathToPom(pbld, mapEntry, vs);
        return new Path(pbld.toString());
    }

    URL getPomURL(URI repoURI, MapEntry mapEntry, VersionMatch vs) throws CoreException {
        StringBuilder pbld = new StringBuilder();
        this.appendFolder(pbld, repoURI.getPath());
        this.appendPathToPom(pbld, mapEntry, vs);
        return MavenReaderType.createURL(repoURI, pbld.toString());
    }

    void setPackaging(ProviderMatch providerMatch, String packaging) {
    }
}

