/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.reader.URLCatalogReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractVersionFinder;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.maven.Messages;
import org.eclipse.buckminster.maven.internal.ILocationResolver;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.maven.internal.MavenComponentType;
import org.eclipse.buckminster.maven.internal.MavenReaderType;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionFormat;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenVersionFinder
extends AbstractVersionFinder
implements ILocationResolver {
    private static final String[] s_allowedExtensions = new String[]{".jar", ".mar"};
    private final MavenReaderType m_readerType;
    private final MapEntry m_mapEntry;
    private final URI m_uri;
    private URL[] m_fileList;

    public MavenVersionFinder(MavenReaderType readerType, Provider provider, IComponentType ctype, NodeQuery query) throws CoreException {
        super(provider, ctype, query);
        this.m_readerType = readerType;
        this.m_uri = readerType.getURI(provider, query.getProperties());
        this.m_mapEntry = MavenReaderType.getGroupAndArtifact(provider, query.getComponentRequest());
    }

    public void close() {
        this.m_fileList = null;
    }

    public VersionMatch getBestVersion(IProgressMonitor monitor) throws CoreException {
        VersionMatch best = null;
        for (VersionMatch candidate : this.getComponentVersions(monitor)) {
            best = this.getBestVersion(candidate, best);
        }
        return best;
    }

    @Override
    public URI getURI() {
        return this.m_uri;
    }

    VersionMatch getBestVersion(VersionMatch a, VersionMatch b) {
        VersionMatch selected;
        VersionMatch rejected;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        Version av = a.getVersion();
        Version bv = b.getVersion();
        String msgFormat = Messages._0_has_no_version;
        if (av == null) {
            if (bv == null) {
                return a;
            }
            rejected = a;
            selected = b;
        } else if (bv == null) {
            rejected = b;
            selected = a;
        } else {
            msgFormat = Messages._0_is_a_better_match;
            if (this.getQuery().compare(a, b) > 0) {
                rejected = b;
                selected = a;
            } else {
                rejected = a;
                selected = b;
            }
        }
        this.logDecision(ResolverDecisionType.MATCH_REJECTED, new Object[]{rejected, NLS.bind((String)msgFormat, (Object)selected)});
        return selected;
    }

    List<VersionMatch> getComponentVersions(IProgressMonitor monitor) throws CoreException {
        NodeQuery query = this.getQuery();
        VersionRange range = query.getVersionRange();
        if (range == null) {
            range = new VersionRange(Version.MIN_VERSION, true, Version.MAX_VERSION, true);
        } else if (range.getFormat().equals((Object)VersionFormat.OSGI_FORMAT)) {
            range = VersionHelper.createRange((VersionFormat)MavenComponentType.getTripletFormat(), (String)range.toString());
        }
        ArrayList<VersionMatch> versions = new ArrayList<VersionMatch>();
        String artifact = String.valueOf(this.m_mapEntry.getArtifactId()) + '-';
        int artifactLen = artifact.length();
        URL[] uRLArray = this.getFileList(range, monitor);
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            URL url = uRLArray[n2];
            IPath path = Path.fromPortableString((String)url.getPath());
            int segCnt = path.segmentCount();
            if (segCnt >= 1 && (fileName = path.segment(segCnt - 1)).startsWith(artifact)) {
                String versionStr;
                VersionMatch versionMatch;
                String extension = null;
                String[] stringArray = s_allowedExtensions;
                int n3 = s_allowedExtensions.length;
                int n4 = 0;
                while (n4 < n3) {
                    String allowedExtension = stringArray[n4];
                    if (fileName.endsWith(allowedExtension)) {
                        extension = allowedExtension;
                        break;
                    }
                    ++n4;
                }
                if (extension != null && (versionMatch = MavenComponentType.createVersionMatch(versionStr = fileName.substring(artifactLen, fileName.length() - extension.length()), String.valueOf(fileName) + '/' + versionStr)) != null && query.isMatch(versionMatch)) {
                    versions.add(versionMatch);
                }
            }
            ++n2;
        }
        return versions;
    }

    MapEntry getMapEntry() {
        return this.m_mapEntry;
    }

    MavenReaderType getReaderType() {
        return this.m_readerType;
    }

    private URL[] createFileList(VersionRange designator, IProgressMonitor monitor) throws CoreException {
        StringBuilder pbld = new StringBuilder();
        this.m_readerType.appendFolder(pbld, this.m_uri.getPath());
        this.m_readerType.appendFolder(pbld, this.m_mapEntry.getGroupId());
        this.m_readerType.appendFolder(pbld, "jars");
        URL jarsURL = MavenReaderType.createURL(this.m_uri, pbld.toString());
        return URLCatalogReaderType.list((URL)jarsURL, (IConnectContext)this.getConnectContext(), (IProgressMonitor)monitor);
    }

    private URL[] getFileList(VersionRange designator, IProgressMonitor monitor) throws CoreException {
        if (this.m_fileList == null) {
            this.m_fileList = this.createFileList(designator, monitor);
        } else {
            MonitorUtils.complete((IProgressMonitor)monitor);
        }
        return this.m_fileList;
    }
}

