/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SplitType implements Enumerator
{
    QUOTED(0, "quoted", "quoted"),
    UNQUOTED(1, "unquoted", "unquoted"),
    GROUPS(2, "groups", "groups");

    public static final int QUOTED_VALUE = 0;
    public static final int UNQUOTED_VALUE = 1;
    public static final int GROUPS_VALUE = 2;
    private static final SplitType[] VALUES_ARRAY;
    public static final List<SplitType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SplitType[]{QUOTED, UNQUOTED, GROUPS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SplitType get(int value) {
        switch (value) {
            case 0: {
                return QUOTED;
            }
            case 1: {
                return UNQUOTED;
            }
            case 2: {
                return GROUPS;
            }
        }
        return null;
    }

    public static SplitType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SplitType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SplitType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SplitType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private SplitType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

