/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.impl;

import java.util.UUID;
import java.util.regex.Pattern;
import org.eclipse.buckminster.model.common.CommonFactory;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.Constant;
import org.eclipse.buckminster.model.common.Documentation;
import org.eclipse.buckminster.model.common.Format;
import org.eclipse.buckminster.model.common.Match;
import org.eclipse.buckminster.model.common.PropertyConstant;
import org.eclipse.buckminster.model.common.PropertyElement;
import org.eclipse.buckminster.model.common.PropertyRef;
import org.eclipse.buckminster.model.common.Replace;
import org.eclipse.buckminster.model.common.RxGroup;
import org.eclipse.buckminster.model.common.RxPattern;
import org.eclipse.buckminster.model.common.Split;
import org.eclipse.buckminster.model.common.SplitType;
import org.eclipse.buckminster.model.common.ToLower;
import org.eclipse.buckminster.model.common.ToUpper;
import org.eclipse.buckminster.model.common.impl.ConstantImpl;
import org.eclipse.buckminster.model.common.impl.DocumentationImpl;
import org.eclipse.buckminster.model.common.impl.FormatImpl;
import org.eclipse.buckminster.model.common.impl.MatchImpl;
import org.eclipse.buckminster.model.common.impl.PropertyConstantImpl;
import org.eclipse.buckminster.model.common.impl.PropertyElementImpl;
import org.eclipse.buckminster.model.common.impl.PropertyRefImpl;
import org.eclipse.buckminster.model.common.impl.ReplaceImpl;
import org.eclipse.buckminster.model.common.impl.RxGroupImpl;
import org.eclipse.buckminster.model.common.impl.RxPatternImpl;
import org.eclipse.buckminster.model.common.impl.SplitImpl;
import org.eclipse.buckminster.model.common.impl.ToLowerImpl;
import org.eclipse.buckminster.model.common.impl.ToUpperImpl;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.osgi.framework.InvalidSyntaxException;

public class CommonFactoryImpl
extends EFactoryImpl
implements CommonFactory {
    @Deprecated
    public static CommonPackage getPackage() {
        return CommonPackage.eINSTANCE;
    }

    public static CommonFactory init() {
        try {
            CommonFactory theCommonFactory = (CommonFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/buckminster/Common-1.0");
            if (theCommonFactory != null) {
                return theCommonFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CommonFactoryImpl();
    }

    public String convertFilterToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertPatternToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertPropertyKeyToString(EDataType eDataType, Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
    }

    public String convertSplitTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 17: {
                return this.convertSplitTypeToString(eDataType, instanceValue);
            }
            case 18: {
                return this.convertPropertyKeyToString(eDataType, instanceValue);
            }
            case 19: {
                return this.convertUuidToString(eDataType, instanceValue);
            }
            case 20: {
                return this.convertPatternToString(eDataType, instanceValue);
            }
            case 21: {
                return this.convertFilterToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertUuidToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createConstant();
            }
            case 1: {
                return this.createDocumentation();
            }
            case 2: {
                return this.createFormat();
            }
            case 3: {
                return this.createMatch();
            }
            case 5: {
                return this.createPropertyConstant();
            }
            case 6: {
                return this.createPropertyElement();
            }
            case 7: {
                return this.createPropertyRef();
            }
            case 8: {
                return this.createReplace();
            }
            case 9: {
                return this.createRxGroup();
            }
            case 11: {
                return this.createRxPattern();
            }
            case 12: {
                return this.createSplit();
            }
            case 13: {
                return this.createToLower();
            }
            case 14: {
                return this.createToUpper();
            }
            case 16: {
                return this.createDocumentRoot();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Constant createConstant() {
        ConstantImpl constant = new ConstantImpl();
        return constant;
    }

    public Documentation createDocumentation() {
        DocumentationImpl documentation = new DocumentationImpl();
        return documentation;
    }

    public EObject createDocumentRoot() {
        EObject documentRoot = super.create(CommonPackage.Literals.DOCUMENT_ROOT);
        return documentRoot;
    }

    public Filter createFilterFromString(EDataType eDataType, String initialValue) {
        try {
            return initialValue == null ? null : FilterFactory.newInstance((String)initialValue);
        }
        catch (InvalidSyntaxException e) {
            return null;
        }
    }

    public Format createFormat() {
        FormatImpl format = new FormatImpl();
        return format;
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 17: {
                return this.createSplitTypeFromString(eDataType, initialValue);
            }
            case 18: {
                return this.createPropertyKeyFromString(eDataType, initialValue);
            }
            case 19: {
                return this.createUuidFromString(eDataType, initialValue);
            }
            case 20: {
                return this.createPatternFromString(eDataType, initialValue);
            }
            case 21: {
                return this.createFilterFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Match createMatch() {
        MatchImpl match = new MatchImpl();
        return match;
    }

    public Pattern createPatternFromString(EDataType eDataType, String initialValue) {
        return Pattern.compile(initialValue);
    }

    public PropertyConstant createPropertyConstant() {
        PropertyConstantImpl propertyConstant = new PropertyConstantImpl();
        return propertyConstant;
    }

    public PropertyElement createPropertyElement() {
        PropertyElementImpl propertyElement = new PropertyElementImpl();
        return propertyElement;
    }

    public String createPropertyKeyFromString(EDataType eDataType, String initialValue) {
        return (String)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
    }

    public PropertyRef createPropertyRef() {
        PropertyRefImpl propertyRef = new PropertyRefImpl();
        return propertyRef;
    }

    public Replace createReplace() {
        ReplaceImpl replace = new ReplaceImpl();
        return replace;
    }

    public RxGroup createRxGroup() {
        RxGroupImpl rxGroup = new RxGroupImpl();
        return rxGroup;
    }

    public RxPattern createRxPattern() {
        RxPatternImpl rxPattern = new RxPatternImpl();
        return rxPattern;
    }

    public Split createSplit() {
        SplitImpl split = new SplitImpl();
        return split;
    }

    public SplitType createSplitTypeFromString(EDataType eDataType, String initialValue) {
        SplitType result = SplitType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public ToLower createToLower() {
        ToLowerImpl toLower = new ToLowerImpl();
        return toLower;
    }

    public ToUpper createToUpper() {
        ToUpperImpl toUpper = new ToUpperImpl();
        return toUpper;
    }

    public UUID createUuidFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : UUID.fromString(initialValue);
    }

    public CommonPackage getCommonPackage() {
        return (CommonPackage)this.getEPackage();
    }
}

