/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.opml.model;

import org.eclipse.buckminster.opml.IBody;
import org.eclipse.buckminster.opml.IHead;
import org.eclipse.buckminster.opml.IOPML;
import org.eclipse.buckminster.opml.builder.OPMLBuilder;
import org.eclipse.buckminster.opml.model.Body;
import org.eclipse.buckminster.opml.model.Head;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OPML
extends UUIDKeyed
implements IOPML {
    public static final String OPML_NAMESPACE = "http://opml.org/spec2";
    public static final String OPML_PREFIX = "opml";
    public static final String OPML_NS_RESOURCE = "/opml-2.0-ns.xsd";
    public static final String ATTR_VERSION = "version";
    public static final String TAG = "opml";
    public static final int SEQUENCE_NUMBER = 1;
    private final Body m_body;
    private final Head m_head;
    private final String m_version;

    public OPML(OPMLBuilder builder) {
        this.m_version = builder.getVersion();
        this.m_head = new Head(builder.getHeadBuilder());
        this.m_body = new Body(builder.getBodyBuilder());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(OPMLBuilder.class)) {
            OPMLBuilder bld = new OPMLBuilder();
            bld.initFrom(this);
            return bld;
        }
        return super.getAdapter(adapter);
    }

    public IBody getBody() {
        return this.m_body;
    }

    public String getDefaultTag() {
        return "opml";
    }

    public IHead getHead() {
        return this.m_head;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        this.toSax(receiver, "", "", "opml");
        receiver.endDocument();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.m_version != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION, (String)this.m_version);
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        this.m_head.toSax(handler, namespace, prefix, this.m_head.getDefaultTag());
        this.m_body.toSax(handler, namespace, prefix, this.m_body.getDefaultTag());
    }

    protected String getElementNamespace(String namespace) {
        return "".equals(namespace) ? "" : OPML_NAMESPACE;
    }

    protected String getElementPrefix(String prefix) {
        return "".equals(prefix) ? "" : "opml";
    }
}

