/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.opml.model;

import java.net.URI;
import java.util.Date;
import org.eclipse.buckminster.opml.IOutline;
import org.eclipse.buckminster.opml.OutlineType;
import org.eclipse.buckminster.opml.builder.OutlineBuilder;
import org.eclipse.buckminster.opml.model.Body;
import org.eclipse.buckminster.opml.model.Head;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Outline
extends Body
implements IOutline {
    public static final String TAG = "outline";
    public static final String ATTR_CATEGORY = "category";
    public static final String ATTR_CREATED = "created";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_HTML_URL = "htmlUrl";
    public static final String ATTR_IS_BREAKPOINT = "isBreakpoint";
    public static final String ATTR_IS_COMMENT = "isComment";
    public static final String ATTR_LANGUAGE = "language";
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_URL = "url";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_XML_URL = "xmlUrl";
    private final boolean m_breakpoint;
    private final String m_category;
    private final boolean m_comment;
    private final Date m_created;
    private final String m_description;
    private final URI m_htmlUrl;
    private final String m_language;
    private final String m_text;
    private final String m_title;
    private final OutlineType m_type;
    private final String m_typeString;
    private final URI m_url;
    private final String m_version;
    private final URI m_xmlUrl;

    public Outline(OutlineBuilder outline) {
        super(outline);
        this.m_breakpoint = outline.isBreakpoint();
        this.m_category = outline.getCategory();
        this.m_comment = outline.isComment();
        this.m_created = outline.getCreated();
        this.m_description = outline.getDescription();
        this.m_htmlUrl = outline.getHtmlUrl();
        this.m_language = outline.getLanguage();
        this.m_text = outline.getText();
        this.m_title = outline.getTitle();
        this.m_type = outline.getType();
        this.m_typeString = outline.getTypeString();
        this.m_url = outline.getUrl();
        this.m_version = outline.getVersion();
        this.m_xmlUrl = outline.getXmlUrl();
    }

    public String getCategory() {
        return this.m_category;
    }

    public Date getCreated() {
        return this.m_created;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public String getDescription() {
        return this.m_description;
    }

    public URI getHtmlUrl() {
        return this.m_htmlUrl;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public String getText() {
        return this.m_text;
    }

    public String getTitle() {
        return this.m_title;
    }

    public OutlineType getType() {
        return this.m_type;
    }

    public String getTypeString() {
        return this.m_typeString;
    }

    public URI getUrl() {
        return this.m_url;
    }

    public String getVersion() {
        return this.m_version;
    }

    public URI getXmlUrl() {
        return this.m_xmlUrl;
    }

    public boolean isBreakpoint() {
        return this.m_breakpoint;
    }

    public boolean isComment() {
        return this.m_comment;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.m_category != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_CATEGORY, (String)this.m_category);
        }
        if (this.m_created != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_CATEGORY, (String)Head.RFC_822_4DY_FORMAT.format(this.m_created));
        }
        if (this.m_description != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_DESCRIPTION, (String)this.m_description);
        }
        if (this.m_htmlUrl != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_HTML_URL, (String)this.m_htmlUrl.toString());
        }
        if (this.m_breakpoint) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_IS_BREAKPOINT, (String)"true");
        }
        if (this.m_comment) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_IS_COMMENT, (String)"true");
        }
        if (this.m_language != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_LANGUAGE, (String)this.m_language);
        }
        if (this.m_text != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TEXT, (String)this.m_text);
        }
        if (this.m_title != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TITLE, (String)this.m_title);
        }
        if (this.m_typeString != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TYPE, (String)this.m_typeString);
        }
        if (this.m_url != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_URL, (String)this.m_url.toString());
        }
        if (this.m_version != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION, (String)this.m_version);
        }
        if (this.m_xmlUrl != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_XML_URL, (String)this.m_xmlUrl.toString());
        }
    }
}

