/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.IBuckminsterPreferenceConstants;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public abstract class BuckminsterPreferences
implements IBuckminsterPreferenceConstants {
    private static final IEclipsePreferences s_prefsNode = new InstanceScope().getNode("org.eclipse.buckminster.runtime");
    private static final IEclipsePreferences s_defaultNode = new DefaultScope().getNode("org.eclipse.buckminster.runtime");

    static {
        s_defaultNode.putInt("logLevelConsole", 1);
        s_defaultNode.putInt("logLevelAntLogger", 2);
        s_defaultNode.putInt("logLevelEclipseLogger", 2);
        s_defaultNode.putBoolean("logEclipseToConsole", false);
        s_defaultNode.put("siteName", "default");
        s_defaultNode.put("queryResolverSortOrder", "rmap");
        s_defaultNode.putInt("connectionRetryCount", 3);
        s_defaultNode.putInt("connectionRetryDelay", 1);
        s_defaultNode.putBoolean("opmlSupport", false);
        s_defaultNode.putBoolean("pref_console_show_on_message", false);
        s_defaultNode.putBoolean("pref_console_show_on_error", true);
        s_defaultNode.putBoolean("pref_console_limit_output", true);
        s_defaultNode.putInt("pref_console_high_water_mark", 500000);
        s_defaultNode.put("pref_console_message_color", "0,0,0");
        s_defaultNode.put("pref_console_error_color", "255,0,0");
        try {
            s_defaultNode.flush();
        }
        catch (BackingStoreException e) {
            Buckminster.getLogger().error(e, e.toString(), new Object[0]);
        }
    }

    public static void addListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        s_prefsNode.addPreferenceChangeListener(listener);
    }

    public static String createQueryResolverSortOrder(String[] sortOrder) {
        if (sortOrder == null || sortOrder.length == 0) {
            return null;
        }
        StringBuffer bld = new StringBuffer();
        int idx = 0;
        while (idx < sortOrder.length) {
            String resolverName = sortOrder[idx];
            if (resolverName != null && (resolverName = resolverName.trim()).length() != 0) {
                if (bld.length() > 0) {
                    bld.append(',');
                }
                bld.append(resolverName);
            }
            ++idx;
        }
        return bld.length() > 0 ? bld.toString() : null;
    }

    public static IPath getBuckminterProjectContents() {
        String tmp = s_prefsNode.get("bmProjectContents", null);
        return tmp == null ? null : new Path(tmp);
    }

    public static int getConnectionRetryCount() {
        return s_prefsNode.getInt("connectionRetryCount", 3);
    }

    public static int getConnectionRetryDelay() {
        return s_prefsNode.getInt("connectionRetryDelay", 1);
    }

    public static String getConsoleErrorColor() {
        return s_prefsNode.get("pref_console_error_color", "255,0,0");
    }

    public static int getConsoleHighWaterMark() {
        return s_prefsNode.getInt("pref_console_high_water_mark", 500000);
    }

    public static String getConsoleMessageColor() {
        return s_prefsNode.get("pref_console_message_color", "0,0,0");
    }

    public static IEclipsePreferences getDefaultNode() {
        return s_defaultNode;
    }

    public static int getLogLevelAntLogger() {
        return s_prefsNode.getInt("logLevelAntLogger", 2);
    }

    public static int getLogLevelConsole() {
        return s_prefsNode.getInt("logLevelConsole", 1);
    }

    public static int getLogLevelEclipseLogger() {
        return s_prefsNode.getInt("logLevelEclipseLogger", 2);
    }

    public static IEclipsePreferences getNode() {
        return s_prefsNode;
    }

    public static String[] getQueryResolverSortOrder() {
        String qrso = s_prefsNode.get("queryResolverSortOrder", "rmap");
        return qrso.split(",");
    }

    public static String getSiteName() {
        return s_prefsNode.get("siteName", "default");
    }

    public static boolean isConsoleLimitOutput() {
        return s_prefsNode.getBoolean("pref_console_limit_output", true);
    }

    public static boolean isConsoleShowOnError() {
        return s_prefsNode.getBoolean("pref_console_show_on_error", true);
    }

    public static boolean isConsoleShowOnMessage() {
        return s_prefsNode.getBoolean("pref_console_show_on_message", false);
    }

    public static boolean isCustomQuerySortOrder() {
        return s_prefsNode.getBoolean("customQueryResolverSort", false);
    }

    public static boolean isEclipseLoggerToConsole() {
        return s_prefsNode.getBoolean("logEclipseToConsole", false);
    }

    public static boolean isOPMLSupport() {
        return s_prefsNode.getBoolean("opmlSupport", false);
    }

    public static void removeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        s_prefsNode.removePreferenceChangeListener(listener);
    }

    public static void save() throws BackingStoreException {
        s_prefsNode.flush();
    }

    public static void setBuckminsterProjectContents(IPath path) {
        if (path == null) {
            s_prefsNode.remove("bmProjectContents");
        } else {
            s_prefsNode.put("bmProjectContents", path.toPortableString());
        }
    }

    public static void setConnectionRetryCount(int retryCount) {
        s_prefsNode.putInt("connectionRetryCount", retryCount);
    }

    public static void setConnectionRetryDelay(int retryDelay) {
        s_prefsNode.putInt("connectionRetryDelay", retryDelay);
    }

    public static void setConsoleErrorColor(String color) {
        if (color == null) {
            s_prefsNode.remove("pref_console_error_color");
        } else {
            s_prefsNode.put("pref_console_error_color", color);
        }
    }

    public static void setConsoleHighWaterMark(int waterMark) {
        s_prefsNode.putInt("pref_console_high_water_mark", waterMark);
    }

    public static void setConsoleLimitOutput(boolean flag) {
        s_prefsNode.putBoolean("pref_console_limit_output", flag);
    }

    public static void setConsoleMessageColor(String color) {
        if (color == null) {
            s_prefsNode.remove("pref_console_message_color");
        } else {
            s_prefsNode.put("pref_console_message_color", color);
        }
    }

    public static void setConsoleShowOnError(boolean flag) {
        s_prefsNode.putBoolean("pref_console_show_on_error", flag);
    }

    public static void setConsoleShowOnMessage(boolean flag) {
        s_prefsNode.putBoolean("pref_console_show_on_message", flag);
    }

    public static void setCustomQueryResolverSortOrder(boolean flag) {
        s_prefsNode.putBoolean("customQueryResolverSort", flag);
    }

    public static void setEclipseLoggerToConsole(boolean flag) {
        s_prefsNode.putBoolean("logEclipseToConsole", flag);
    }

    public static void setLogLevelAntLogger(int logLevel) {
        s_prefsNode.putInt("logLevelAntLogger", logLevel);
    }

    public static void setLogLevelConsole(int logLevel) {
        s_prefsNode.putInt("logLevelConsole", logLevel);
    }

    public static void setLogLevelEclipseLogger(int logLevel) {
        s_prefsNode.putInt("logLevelEclipseLogger", logLevel);
    }

    public static void setOPMLSupport(boolean flag) {
        s_prefsNode.putBoolean("opmlSupport", flag);
    }

    public static void setQueryResolverSortOrder(String[] sortOrder) {
        String sortOrderString = BuckminsterPreferences.createQueryResolverSortOrder(sortOrder);
        if (sortOrderString == null) {
            s_prefsNode.remove("queryResolverSortOrder");
        } else {
            s_prefsNode.put("queryResolverSortOrder", sortOrderString);
        }
    }

    public static void setSiteName(String siteName) {
        if (siteName == null) {
            s_prefsNode.remove("siteName");
        } else {
            s_prefsNode.put("siteName", siteName);
        }
    }
}

