/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.util.Properties;
import org.eclipse.buckminster.runtime.IFileInfo;

public class FileInfoBuilder
implements IFileInfo {
    private String m_contentType;
    private long m_lastModified = 0L;
    private String m_name;
    private long m_size = -1L;

    public FileInfoBuilder() {
    }

    public FileInfoBuilder(IFileInfo fileInfo) {
        this.initFrom(fileInfo);
    }

    public FileInfoBuilder(Properties properties) {
        this.m_name = properties.getProperty("name");
        this.m_contentType = properties.getProperty("contentType");
        String v = properties.getProperty("lastModified");
        if (v != null) {
            this.m_lastModified = Long.parseLong(v);
        }
        if ((v = properties.getProperty("size")) != null) {
            this.m_size = Long.parseLong(v);
        }
    }

    public void addProperties(Properties properties) {
        if (this.m_contentType != null) {
            properties.setProperty("contentType", this.m_contentType);
        }
        if (this.m_lastModified != 0L) {
            properties.setProperty("lastModified", Long.toString(this.m_lastModified));
        }
        if (this.m_name != null) {
            properties.setProperty("name", this.m_name);
        }
        if (this.m_size != -1L) {
            properties.setProperty("size", Long.toString(this.m_size));
        }
    }

    public final String getContentType() {
        return this.m_contentType;
    }

    public long getLastModified() {
        return this.m_lastModified;
    }

    public final String getRemoteName() {
        return this.m_name;
    }

    public final long getSize() {
        return this.m_size;
    }

    public void initFrom(IFileInfo info) {
        this.setName(info.getRemoteName());
        this.setContentType(info.getContentType());
        this.setSize(info.getSize());
        this.setLastModified(info.getLastModified());
    }

    public void reset() {
        this.m_name = null;
        this.m_contentType = null;
        this.m_size = -1L;
        this.m_lastModified = 0L;
    }

    public final void setContentType(String contentType) {
        this.m_contentType = contentType;
    }

    public void setLastModified(long timestamp) {
        this.m_lastModified = timestamp;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setSize(long size) {
        this.m_size = size;
    }
}

