/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class IOUtils {
    public static void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void copy(InputStream in, OutputStream out, IProgressMonitor monitor) throws IOException {
        MonitorUtils.begin(monitor, -1);
        try {
            int len;
            byte[] buffer = new byte[2048];
            while ((len = in.read(buffer)) > 0) {
                MonitorUtils.worked(monitor, 1);
                out.write(buffer, 0, len);
            }
        }
        finally {
            MonitorUtils.done(monitor);
        }
    }

    public static final void copy(Reader in, Writer out, IProgressMonitor monitor) throws IOException {
        MonitorUtils.begin(monitor, -1);
        try {
            int len;
            char[] buffer = new char[1024];
            while ((len = in.read(buffer)) > 0) {
                MonitorUtils.worked(monitor, 1);
                out.write(buffer, 0, len);
            }
        }
        finally {
            MonitorUtils.done(monitor);
        }
    }

    public static URI uri(String uriStr) {
        try {
            return uriStr == null ? null : new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to convert String into URI: " + uriStr);
        }
    }

    public static URI uri(URL url) {
        try {
            return url == null ? null : url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to convert URL into URI: " + url);
        }
    }

    public static URL url(File file) {
        return file == null ? null : IOUtils.url(file.toURI());
    }

    public static URL url(URI uri) {
        try {
            return uri == null ? null : uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to convert URI into URL: " + uri);
        }
    }
}

