/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.sax;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static SAXTransformerFactory s_saxTransformerFactory;
    private static final Class<?>[] s_emptyArgTypes;
    private static final Object[] s_emptyArgs;
    private static final SAXParserFactory s_parserFactory;

    static {
        s_emptyArgTypes = new Class[0];
        s_emptyArgs = new Object[0];
        s_parserFactory = SAXParserFactory.newInstance();
    }

    public static void addAttribute(AttributesImpl attrs, String name, String value) {
        attrs.addAttribute("", name, name, "CDATA", value);
    }

    public static <T> List<T> createUnmodifiableList(Collection<T> coll) {
        List aList;
        if (coll == null || coll.size() == 0) {
            aList = Collections.emptyList();
        } else {
            List<T> newList;
            if (coll.size() == 1) {
                Object value = coll instanceof List ? ((List)coll).get(0) : coll.iterator().next();
                newList = Collections.singletonList(value);
            } else {
                newList = new ArrayList<T>(coll);
            }
            aList = Collections.unmodifiableList(newList);
        }
        return aList;
    }

    public static <K, V> Map<K, V> createUnmodifiableMap(Map<K, V> aMap) {
        if (aMap == null || aMap.size() == 0) {
            aMap = Collections.emptyMap();
        } else {
            if (aMap.size() == 1) {
                Map.Entry<K, V> entry = aMap.entrySet().iterator().next();
                aMap = Collections.singletonMap(entry.getKey(), entry.getValue());
            } else {
                aMap = new HashMap<K, V>(aMap);
            }
            aMap = Collections.unmodifiableMap(aMap);
        }
        return aMap;
    }

    public static <T> Set<T> createUnmodifiableSet(Collection<T> coll) {
        Set aSet;
        if (coll == null || coll.size() == 0) {
            aSet = Collections.emptySet();
        } else {
            Set<T> newSet;
            if (coll.size() == 1) {
                Object value = coll instanceof List ? ((List)coll).get(0) : coll.iterator().next();
                newSet = Collections.singleton(value);
            } else {
                newSet = new HashSet<T>(coll);
            }
            aSet = Collections.unmodifiableSet(newSet);
        }
        return aSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLReader createXMLReader(boolean validating, boolean withNamespace) throws SAXException {
        try {
            SAXParserFactory sAXParserFactory = s_parserFactory;
            synchronized (sAXParserFactory) {
                s_parserFactory.setValidating(validating);
                s_parserFactory.setNamespaceAware(withNamespace);
                return s_parserFactory.newSAXParser().getXMLReader();
            }
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public static <T extends ISaxableElement> void emitCollection(String namespace, String prefix, String localName, String elemName, Attributes attrs, Collection<T> collection, ContentHandler handler) throws SAXException {
        if (collection.isEmpty() && attrs.getLength() == 0) {
            return;
        }
        String qName = Utils.makeQualifiedName(prefix, localName);
        handler.startElement(namespace, localName, qName, attrs);
        for (ISaxableElement elem : collection) {
            elem.toSax(handler, namespace, prefix, elemName == null ? elem.getDefaultTag() : elemName);
        }
        handler.endElement(namespace, localName, qName);
    }

    public static <T extends ISaxableElement> void emitCollection(String namespace, String prefix, String localName, String elemName, Attributes attrs, T[] array, ContentHandler handler) throws SAXException {
        if (array.length == 0) {
            return;
        }
        String qName = Utils.makeQualifiedName(prefix, localName);
        handler.startElement(namespace, localName, qName, attrs);
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T elem = TArray[n2];
            elem.toSax(handler, namespace, prefix, elemName == null ? elem.getDefaultTag() : elemName);
            ++n2;
        }
        handler.endElement(namespace, localName, qName);
    }

    public static <T extends ISaxableElement> void emitCollection(String namespace, String prefix, String localName, String elemName, Collection<T> collection, ContentHandler handler) throws SAXException {
        Utils.emitCollection(namespace, prefix, localName, elemName, ISaxableElement.EMPTY_ATTRIBUTES, collection, handler);
    }

    public static String getEncoding(Locator locator) {
        String enc = null;
        if (locator != null) {
            try {
                enc = (String)locator.getClass().getMethod("getEncoding", s_emptyArgTypes).invoke((Object)locator, s_emptyArgs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (enc == null) {
            enc = "UTF-8";
        }
        return enc;
    }

    public static byte[] getImage(ISaxable saxable) {
        try {
            ByteArrayOutputStream builder = new ByteArrayOutputStream();
            Utils.serializeUgly(saxable, builder);
            return builder.toByteArray();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getInputStream(ISaxable saxable) throws SAXException {
        ByteInputOutputBuffer builder = new ByteInputOutputBuffer();
        Utils.serialize(saxable, builder);
        return builder.getInputStream();
    }

    public static String makeQualifiedName(String prefix, String localName) {
        return prefix == null || prefix.length() == 0 ? localName : String.valueOf(prefix) + ':' + localName;
    }

    public static ContentHandler newSerializer(File file, OutputStream stream, String encoding, int indent, boolean useSysLinesep) throws SAXException {
        TransformerHandler serializer = Utils.createTransformerHandler(indent);
        Transformer t = serializer.getTransformer();
        t.setOutputProperty("method", "xml");
        if (encoding != null) {
            t.setOutputProperty("encoding", encoding);
        }
        if (indent >= 0) {
            t.setOutputProperty("indent", "yes");
        }
        StreamResult out = new StreamResult();
        if (file != null) {
            out.setSystemId(file);
        }
        try {
            if (encoding == null) {
                encoding = t.getOutputProperty("encoding");
            }
            out.setWriter(new OutputStreamWriter(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new SAXException(e.getMessage());
        }
        String lineSep = System.getProperty("line.separator");
        if (useSysLinesep || "\n".equals(lineSep)) {
            serializer.setResult(out);
        } else {
            System.setProperty("line.separator", "\n");
            try {
                serializer.setResult(out);
            }
            finally {
                System.setProperty("line.separator", lineSep);
            }
        }
        return serializer;
    }

    public static void serialize(ISaxable saxable, OutputStream outputStream) throws SAXException {
        ContentHandler serializer = Utils.newSerializer(null, outputStream, "UTF-8", 4, true);
        saxable.toSax(serializer);
    }

    public static void serializeUgly(ISaxable saxable, OutputStream outputStream) throws SAXException {
        ContentHandler serializer = Utils.newSerializer(null, outputStream, "UTF-8", -1, false);
        saxable.toSax(serializer);
    }

    private static synchronized TransformerHandler createTransformerHandler(int indent) throws SAXException {
        if (s_saxTransformerFactory == null) {
            TransformerFactory tf = TransformerFactory.newInstance();
            if (!tf.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                throw new SAXException("The TransformerFactory is not a SAXTransformerFactory");
            }
            s_saxTransformerFactory = (SAXTransformerFactory)tf;
        }
        try {
            s_saxTransformerFactory.setAttribute("indent-number", Integer.toString(indent));
        }
        catch (IllegalArgumentException tf) {
            // empty catch block
        }
        try {
            return s_saxTransformerFactory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private static class ByteInputOutputBuffer
    extends ByteArrayOutputStream {
        private ByteInputOutputBuffer() {
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

