/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.macosx;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.internal.launching.macosx.MacOSXLaunchingPlugin;
import org.eclipse.jdt.internal.launching.macosx.MacOSXVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;

public class MacOSXVMInstallType
extends StandardVMType {
    private static final String JVM_VERSION_LOC = "/System/Library/Frameworks/JavaVM.framework/Versions/";
    private static final String CURRENT_JVM = "CurrentJDK";
    private static final String JVM_ROOT = "Home";
    private static final String JAVADOC_LOC = "/Developer/Documentation/Java/Reference/";
    private static final String JAVADOC_SUBDIR = "/doc/api";

    public String getName() {
        return MacOSXLaunchingPlugin.getString("MacOSXVMType.name");
    }

    public IVMInstall doCreateVMInstall(String id) {
        return new MacOSXVMInstall((IVMInstallType)this, id);
    }

    public File detectInstallLocation() {
        String javaVMName = System.getProperty("java.vm.name");
        if (javaVMName == null) {
            return null;
        }
        File defaultLocation = null;
        File versionDir = new File(JVM_VERSION_LOC);
        if (versionDir.exists() && versionDir.isDirectory()) {
            File currentJDK = new File(versionDir, CURRENT_JVM);
            try {
                currentJDK = currentJDK.getCanonicalFile();
            }
            catch (IOException iOException) {}
            File[] versions = versionDir.listFiles();
            int i = 0;
            while (i < versions.length) {
                String version = versions[i].getName();
                File home = new File(versions[i], JVM_ROOT);
                if (home.exists()) {
                    boolean isDefault = currentJDK.equals(versions[i]);
                    IVMInstall install = this.findVMInstall(version);
                    if (install == null && !CURRENT_JVM.equals(version)) {
                        VMStandin vm = new VMStandin((IVMInstallType)this, version);
                        vm.setInstallLocation(home);
                        String format = MacOSXLaunchingPlugin.getString(isDefault ? "MacOSXVMType.jvmDefaultName" : "MacOSXVMType.jvmName");
                        vm.setName(MessageFormat.format(format, version));
                        vm.setLibraryLocations(this.getDefaultLibraryLocations(home));
                        URL doc = this.getDefaultJavadocLocation(home);
                        if (doc != null) {
                            vm.setJavadocLocation(doc);
                        }
                        IVMInstall rvm = vm.convertToRealVM();
                        if (isDefault) {
                            defaultLocation = home;
                            try {
                                JavaRuntime.setDefaultVMInstall((IVMInstall)rvm, null);
                            }
                            catch (CoreException e) {
                                LaunchingPlugin.log((Throwable)e);
                            }
                        }
                    } else if (isDefault) {
                        defaultLocation = home;
                        try {
                            JavaRuntime.setDefaultVMInstall((IVMInstall)install, null);
                        }
                        catch (CoreException e) {
                            LaunchingPlugin.log((Throwable)e);
                        }
                    }
                }
                ++i;
            }
        }
        return defaultLocation;
    }

    protected LibraryInfo getDefaultLibraryInfo(File installLocation) {
        File classes = new File(installLocation, "../Classes");
        File lib1 = new File(classes, "classes.jar");
        File lib2 = new File(classes, "ui.jar");
        String[] libs = new String[]{lib1.toString(), lib2.toString()};
        File lib = new File(installLocation, "lib");
        File extDir = new File(lib, "ext");
        String[] dirs = null;
        dirs = extDir == null ? new String[]{} : new String[]{extDir.getAbsolutePath()};
        File endDir = new File(lib, "endorsed");
        String[] endDirs = null;
        endDirs = endDir == null ? new String[]{} : new String[]{endDir.getAbsolutePath()};
        return new LibraryInfo("???", libs, dirs, endDirs);
    }

    protected IPath getDefaultSystemLibrarySource(File libLocation) {
        File parent = libLocation.getParentFile();
        while (parent != null) {
            File home = new File(parent, JVM_ROOT);
            File parentsrc = new File(home, "src.jar");
            if (parentsrc.isFile()) {
                this.setDefaultRootPath("src");
                return new Path(parentsrc.getPath());
            }
            parentsrc = new File(home, "src.zip");
            if (parentsrc.isFile()) {
                this.setDefaultRootPath("");
                return new Path(parentsrc.getPath());
            }
            parent = parent.getParentFile();
        }
        this.setDefaultRootPath("");
        return Path.EMPTY;
    }

    public IStatus validateInstallLocation(File javaHome) {
        String id = MacOSXLaunchingPlugin.getUniqueIdentifier();
        File java = new File(javaHome, "bin" + File.separator + "java");
        if (java.isFile()) {
            return new Status(0, id, 0, "ok", null);
        }
        return new Status(4, id, 0, MacOSXLaunchingPlugin.getString("MacOSXVMType.error.notRoot"), null);
    }

    public URL getDefaultJavadocLocation(File installLocation) {
        String id = null;
        try {
            String post = String.valueOf(File.separator) + JVM_ROOT;
            String path = installLocation.getCanonicalPath();
            if (path.startsWith(JVM_VERSION_LOC) && path.endsWith(post)) {
                id = path.substring(JVM_VERSION_LOC.length(), path.length() - post.length());
            }
        }
        catch (IOException iOException) {}
        if (id != null) {
            String s = JAVADOC_LOC + id + JAVADOC_SUBDIR;
            File docLocation = new File(s);
            if (!docLocation.exists() && !(docLocation = new File(s = JAVADOC_LOC + id)).exists()) {
                s = null;
            }
            if (s != null) {
                try {
                    return new URL("file", "", s);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return super.getDefaultJavadocLocation(installLocation);
    }

    protected String getVMVersion(File javaHome, File javaExecutable) {
        return super.getVMVersion(javaHome, javaExecutable);
    }
}

