/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.releng.build;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BuildType implements Enumerator
{
    CONTINUOUS(0, "Continuous", "C"),
    NIGHTLY(1, "Nightly", "N"),
    INTEGRATION(2, "Integration", "I"),
    STABLE(3, "Stable", "S"),
    RELEASE(4, "Release", "R"),
    MAINTENANCE(5, "Maintenance", "M");

    public static final int CONTINUOUS_VALUE = 0;
    public static final int NIGHTLY_VALUE = 1;
    public static final int INTEGRATION_VALUE = 2;
    public static final int STABLE_VALUE = 3;
    public static final int RELEASE_VALUE = 4;
    public static final int MAINTENANCE_VALUE = 5;
    private static final BuildType[] VALUES_ARRAY;
    public static final List<BuildType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BuildType[]{CONTINUOUS, NIGHTLY, INTEGRATION, STABLE, RELEASE, MAINTENANCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BuildType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BuildType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BuildType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BuildType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BuildType get(int value) {
        switch (value) {
            case 0: {
                return CONTINUOUS;
            }
            case 1: {
                return NIGHTLY;
            }
            case 2: {
                return INTEGRATION;
            }
            case 3: {
                return STABLE;
            }
            case 4: {
                return RELEASE;
            }
            case 5: {
                return MAINTENANCE;
            }
        }
        return null;
    }

    private BuildType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

