/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.releng.build;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OS implements Enumerator
{
    WIN32(0, "win32", "win32"),
    LINUX(1, "linux", "linux"),
    MACOSX(2, "macosx", "macosx");

    public static final int WIN32_VALUE = 0;
    public static final int LINUX_VALUE = 1;
    public static final int MACOSX_VALUE = 2;
    private static final OS[] VALUES_ARRAY;
    public static final List<OS> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OS[]{WIN32, LINUX, MACOSX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OS get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OS result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OS getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OS result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OS get(int value) {
        switch (value) {
            case 0: {
                return WIN32;
            }
            case 1: {
                return LINUX;
            }
            case 2: {
                return MACOSX;
            }
        }
        return null;
    }

    private OS(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

