/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline;

import java.util.ArrayList;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.IllegalCommandAliasException;
import org.eclipse.buckminster.cmdline.Messages;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class CommandInfo {
    public static final int NORMAL = 0;
    public static final int DEPRECATED = 1;
    public static final int HIDDEN = 2;
    public static final int DISABLED = 3;
    private static final String COMMAND_EXTPOINT = "org.eclipse.buckminster.cmdline.commands";
    private static final String ALIAS_ELEMENTS = "alias";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DEPRECATED_BY_ATTRIBUTE = "deprecatedBy";
    private static final char PERIOD_CHARACTER = '.';
    private static final String STATUS_ATTRIBUTE = "status";
    private static final String ADD_HELP_FLAGS_ATTRIBUTE = "addhelpflags";
    private static CommandInfo[] s_commandInfos;
    private final String[] m_aliases;
    private final IConfigurationElement m_cfgElement;
    private final String m_deprecatedBy;
    private final String m_name;
    private final String[] m_allNames;
    private final String m_namespace;
    private final int m_status;

    public static CommandInfo getCommand(String commandName) throws UsageException {
        CommandInfo ci;
        ArrayList<CommandInfo> matches = new ArrayList<CommandInfo>();
        CommandInfo[] implementors = CommandInfo.getImplementors();
        int top = implementors.length;
        StringBuffer sb = new StringBuffer();
        int idx = 0;
        while (idx < top) {
            ci = implementors[idx];
            if (ci.getStatus() != 3) {
                String[] allNames = ci.getAllNames();
                int nidx = 0;
                while (nidx < allNames.length) {
                    String[] parts = allNames[nidx].split("\\.");
                    int len = parts.length;
                    int i = 0;
                    while (i < len) {
                        sb.setLength(0);
                        int j = len - i - 1;
                        while (j < len) {
                            if (sb.length() != 0) {
                                sb.append('.');
                            }
                            sb.append(parts[j]);
                            ++j;
                        }
                        if (sb.toString().equals(commandName)) {
                            matches.add(ci);
                        }
                        ++i;
                    }
                    ++nidx;
                }
            }
            ++idx;
        }
        int foundMatches = matches.size();
        if (foundMatches == 0) {
            throw new UsageException(NLS.bind((String)Messages.CommandInfo_Command_0_not_found, (Object)commandName));
        }
        if (foundMatches > 1) {
            sb.setLength(0);
            sb.append(NLS.bind((String)Messages.CommandInfo_Multiple_matches_for_0_for, (Object)commandName));
            int idx2 = 0;
            while (idx2 < foundMatches) {
                CommandInfo ci2 = (CommandInfo)matches.get(idx2);
                sb.append(ci2.getFullName());
                sb.append(NLS.bind((String)Messages.CommandInfo_implemented_by_class_0, (Object)ci2.getImplementingClass()));
                if (idx2 < foundMatches - 1) {
                    sb.append(", ");
                }
                ++idx2;
            }
            throw new UsageException(sb.toString());
        }
        ci = (CommandInfo)matches.get(0);
        if (ci.getStatus() == 1) {
            sb.setLength(0);
            sb.append(NLS.bind((String)Messages.CommandInfo_Command_0_is_deprecated, (Object)ci.getName()));
            String by = ci.getDeprecatedBy();
            if (by != null) {
                sb.append(NLS.bind((String)Messages.CommandInfo_Use_command_0_instead, (Object)by));
            }
            Buckminster.getLogger().warning(sb.toString(), new Object[0]);
        }
        return ci;
    }

    public static synchronized CommandInfo[] getImplementors() {
        if (s_commandInfos == null) {
            IExtensionRegistry er = Platform.getExtensionRegistry();
            IConfigurationElement[] elems = er.getConfigurationElementsFor(COMMAND_EXTPOINT);
            s_commandInfos = new CommandInfo[elems.length];
            int i = 0;
            while (i < elems.length) {
                CommandInfo.s_commandInfos[i] = new CommandInfo(elems[i]);
                ++i;
            }
        }
        return s_commandInfos;
    }

    private static int parseCommandStatus(String statusString) {
        int status;
        if ("normal".equalsIgnoreCase(statusString)) {
            status = 0;
        } else if ("deprecated".equalsIgnoreCase(statusString)) {
            status = 1;
        } else if ("hidden".equalsIgnoreCase(statusString)) {
            status = 2;
        } else if ("disabled".equalsIgnoreCase(statusString)) {
            status = 3;
        } else {
            throw new IllegalArgumentException(NLS.bind((String)Messages.CommandInfo__0_is_not_a_valid_command_status, (Object)statusString));
        }
        return status;
    }

    private CommandInfo(IConfigurationElement cfgElement) {
        this.m_cfgElement = cfgElement;
        this.m_status = CommandInfo.parseCommandStatus(cfgElement.getAttribute(STATUS_ATTRIBUTE));
        IExtension ext = this.m_cfgElement.getDeclaringExtension();
        StringBuffer ns = new StringBuffer(ext.getNamespaceIdentifier());
        String name = cfgElement.getAttribute(NAME_ATTRIBUTE);
        int period = name.lastIndexOf(46);
        if (period != -1) {
            ns.append('.').append(name.substring(0, period));
            name = name.substring(period + 1);
        }
        this.m_namespace = ns.toString();
        this.m_name = name;
        IConfigurationElement[] aliasElements = cfgElement.getChildren(ALIAS_ELEMENTS);
        this.m_aliases = new String[aliasElements.length];
        int i = 0;
        while (i < this.m_aliases.length) {
            String alias = aliasElements[i].getAttribute(NAME_ATTRIBUTE);
            if (alias.indexOf(46) != -1) {
                throw new IllegalCommandAliasException(alias);
            }
            this.m_aliases[i] = alias;
            ++i;
        }
        this.m_allNames = new String[1 + this.m_aliases.length];
        this.m_allNames[0] = String.valueOf(this.m_namespace) + '.' + this.m_name;
        i = 0;
        while (i < this.m_aliases.length) {
            this.m_allNames[i + 1] = String.valueOf(this.m_namespace) + '.' + this.m_aliases[i];
            ++i;
        }
        this.m_deprecatedBy = cfgElement.getAttribute(DEPRECATED_BY_ATTRIBUTE);
    }

    public AbstractCommand createInstance() throws CoreException {
        AbstractCommand cmd = (AbstractCommand)this.m_cfgElement.createExecutableExtension(CLASS_ATTRIBUTE);
        cmd.init(Boolean.valueOf(this.m_cfgElement.getAttribute(ADD_HELP_FLAGS_ATTRIBUTE)));
        return cmd;
    }

    public String[] getAliases() {
        return this.m_aliases;
    }

    public String[] getAllNames() {
        return this.m_allNames;
    }

    public IConfigurationElement getCfgElement() {
        return this.m_cfgElement;
    }

    public String getDeprecatedBy() {
        return this.m_deprecatedBy;
    }

    public String getFullName() {
        return this.m_allNames[0];
    }

    public String getImplementingClass() {
        return this.m_cfgElement.getAttribute(CLASS_ATTRIBUTE);
    }

    public String getName() {
        return this.m_name;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public int getStatus() {
        return this.m_status;
    }
}

