/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.PrintStream;
import java.util.List;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.BasicPreferenceHandler;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.PreferenceMappingManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPreferences
extends AbstractCommand {
    private static final OptionDescriptor TEST_DESCRIPTOR = new OptionDescriptor(null, "__test", 1);
    private boolean m_test = false;
    private String m_pattern = null;

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(TEST_DESCRIPTOR);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(TEST_DESCRIPTOR)) {
            this.m_test = true;
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 1) {
            throw new SimpleErrorExitException(Messages.Too_many_arguments);
        }
        if (len == 1) {
            this.m_pattern = unparsed[0];
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        PrintStream out = System.out;
        List<BasicPreferenceHandler> handlers = PreferenceMappingManager.getInstance(this.m_test).getAllHandlers(this.m_pattern);
        int top = handlers.size();
        if (top == 0) {
            out.print(Messages.No_preferences_found);
            if (this.m_pattern != null) {
                out.format(NLS.bind((String)Messages.Is_the_pattern_0_correct, (Object)this.m_pattern), new Object[0]);
            }
            out.println();
            return 0;
        }
        out.print(Messages.Found);
        out.print(top);
        out.println(Messages.Preferences);
        int idx = 0;
        while (idx < top) {
            String v;
            BasicPreferenceHandler bph = handlers.get(idx);
            out.println(bph.getName());
            if (bph.getDescription() != null) {
                out.print(Messages.Description);
                out.println(bph.getDescription());
            }
            if (bph.getKey() != null) {
                out.print(Messages.Key);
                out.println(bph.getKey());
            }
            try {
                v = bph.get(null);
            }
            catch (CoreException e) {
                v = NLS.bind((String)Messages.Unable_to_obtain_value_0, (Object)e.getMessage());
            }
            if (v == null) {
                out.println(Messages.No_value_set);
            } else {
                out.print(Messages.Value);
                out.println(v);
            }
            ++idx;
        }
        return 0;
    }
}

