/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedDependency {
    private final ComponentRequest m_request;
    private final Set<String> m_attributes;

    public QualifiedDependency(ComponentRequest request, Collection<String> attributes) {
        this.m_request = request;
        this.m_attributes = Utils.createUnmodifiableSet(attributes);
    }

    public QualifiedDependency applyAdvice(IAdvisorNode advice) {
        Collection<String> attrs;
        if (advice == null) {
            return this;
        }
        boolean change = false;
        ComponentRequest request = this.m_request;
        VersionRange dsg = advice.getVersionOverride();
        if (dsg != null) {
            change = true;
            request = new ComponentRequest(request.getName(), request.getComponentTypeID(), dsg);
        }
        if ((attrs = advice.getAttributes()).size() > 0) {
            change = true;
            if (advice.isPrune() && this.m_attributes.size() > 0 && !this.m_attributes.containsAll(attrs)) {
                HashSet<String> pruned = new HashSet<String>();
                for (String attrName : attrs) {
                    if (!this.m_attributes.contains(attrName)) continue;
                    pruned.add(attrName);
                }
                if (pruned.size() == 0) {
                    return null;
                }
                attrs = pruned;
            }
        } else {
            attrs = this.m_attributes;
        }
        return change ? new QualifiedDependency(request, attrs) : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QualifiedDependency)) {
            return false;
        }
        QualifiedDependency that = (QualifiedDependency)o;
        return this.m_request.equals(that.m_request) && this.m_attributes.equals(that.m_attributes);
    }

    public final Set<String> getAttributeNames() {
        return this.m_attributes;
    }

    public final ComponentRequest getRequest() {
        return this.m_request;
    }

    public boolean hasAllAttributes(Collection<String> attributes) {
        return this.m_attributes.containsAll(attributes);
    }

    public boolean hasAllAttributes(String[] attributes) {
        return this.hasAllAttributes(Arrays.asList(attributes));
    }

    public int hashCode() {
        return this.m_request.hashCode() * 31 + this.m_attributes.hashCode();
    }

    public QualifiedDependency mergeDependency(QualifiedDependency newQDep) throws CoreException {
        Set<String> allAttrs;
        Set<String> attrs = newQDep.getAttributeNames();
        ComponentRequest newRequest = this.m_request.mergeDesignator(newQDep.getRequest());
        if (newRequest == this.m_request && this.hasAllAttributes(attrs)) {
            return this;
        }
        if (this.m_attributes.size() == 0) {
            allAttrs = attrs;
        } else if (attrs.size() == 0) {
            allAttrs = this.m_attributes;
        } else {
            allAttrs = new HashSet<String>(this.m_attributes);
            allAttrs.addAll(attrs);
        }
        return new QualifiedDependency(newRequest, allAttrs);
    }
}

