/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.util.Collections;
import java.util.List;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecElementBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeBuilder
extends CSpecElementBuilder
implements IAttribute {
    private Documentation m_documentation;
    private Filter m_filter = null;

    AttributeBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
    }

    @Override
    public void clear() {
        super.clear();
        this.m_documentation = null;
        this.m_filter = null;
    }

    public Attribute createAttribute() {
        return new Attribute(this);
    }

    @Override
    public AttributeBuilder getAttributeBuilder(CSpecBuilder specBuilder) {
        return specBuilder == this.getCSpecBuilder() ? this : new AttributeBuilder(specBuilder);
    }

    @Override
    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    @Override
    public Filter getFilter() {
        return this.m_filter;
    }

    public IPath getPrerequisiteRebase() {
        return null;
    }

    @Override
    public List<? extends IPrerequisite> getPrerequisites() {
        return Collections.emptyList();
    }

    @Override
    public String getQualifiedName() {
        return String.valueOf(this.getCSpecBuilder().getComponentIdentifier().toString()) + '#' + this.getName();
    }

    public void initFrom(IAttribute attribute) {
        super.initFrom(attribute.getName());
        this.m_documentation = attribute.getDocumentation();
        this.m_filter = attribute.getFilter();
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    public void setDocumentation(Documentation documentation) {
        this.m_documentation = documentation;
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }
}

