/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecElementBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.Generator;
import org.eclipse.equinox.internal.provisional.p2.core.Version;

public class GeneratorBuilder
extends CSpecElementBuilder
implements IGenerator {
    private String m_attribute;
    private String m_component;
    private String m_generatesType;
    private Version m_generatesVersion;

    GeneratorBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
    }

    public void clear() {
        super.clear();
        this.m_component = null;
        this.m_attribute = null;
        this.m_generatesType = null;
        this.m_generatesVersion = null;
    }

    public Generator createGenerator(CSpec cspec) {
        return new Generator(cspec, this.m_component, this.m_attribute, this.getGeneratedIdentifier());
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public String getComponent() {
        return this.m_component;
    }

    public ComponentIdentifier getGeneratedIdentifier() {
        return new ComponentIdentifier(this.getName(), this.m_generatesType, this.m_generatesVersion);
    }

    public String getGenerates() {
        return this.getName();
    }

    public void initFrom(IGenerator generator) {
        IComponentIdentifier ci = generator.getGeneratedIdentifier();
        super.initFrom(ci.getName());
        this.m_component = generator.getComponent();
        this.m_attribute = generator.getAttribute();
        this.m_generatesType = ci.getComponentTypeID();
        this.m_generatesVersion = ci.getVersion();
    }

    public void setAttribute(String attribute) {
        this.m_attribute = attribute;
    }

    public void setComponent(String component) {
        this.m_component = component;
    }

    public void setGeneratesType(String generatesType) {
        this.m_generatesType = generatesType;
    }

    public void setGeneratesVersion(Version version) {
        this.m_generatesVersion = version;
    }
}

