/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.buckminster.core.cspec.IArtifact;
import org.eclipse.buckminster.core.cspec.IAttributeFilter;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.cspec.SaxablePath;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.internal.actor.PerformManager;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artifact
extends TopLevelAttribute
implements IArtifact {
    public static final String ATTR_PATH = "path";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_BASE = "base";
    private final IPath m_base;
    private final Set<IPath> m_paths;

    public Artifact(ArtifactBuilder builder) {
        super(builder);
        IPath base = builder.getBase();
        if (base != null && !base.hasTrailingSeparator()) {
            base = base.addTrailingSeparator();
        }
        this.m_base = base;
        this.m_paths = CSpec.createUnmodifiablePaths(builder.getPaths());
    }

    @Override
    public IPath getBase() {
        return this.m_base;
    }

    @Override
    public Set<IPath> getPaths() {
        return this.m_paths;
    }

    @Override
    @Deprecated
    public final String getType() {
        return null;
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.m_paths.size() == 1) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PATH, (String)this.m_paths.iterator().next().toPortableString());
        }
        if (this.m_base != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BASE, (String)this.m_base.toPortableString());
        }
    }

    @Override
    protected AttributeBuilder createAttributeBuilder(CSpecBuilder cspecBuilder) {
        return cspecBuilder.createArtifactBuilder();
    }

    @Override
    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        super.emitElements(handler, namespace, prefix);
        if (this.m_paths.size() > 1) {
            for (IPath path : this.m_paths) {
                SaxablePath sPath = (SaxablePath)path;
                sPath.toSax(handler, namespace, prefix, sPath.getDefaultTag());
            }
        }
    }

    protected IPath getExpandedBase(Map<String, ? extends Object> local) throws CoreException {
        if (this.m_base == null) {
            return this.getCSpec().getComponentLocation();
        }
        IPath base = PerformManager.expandPath(local, this.m_base);
        return base.isAbsolute() ? base : this.getCSpec().getComponentLocation().append(base);
    }

    @Override
    protected PathGroup[] internalGetPathGroups(IModelCache ctx, Map<String, ? extends Object> local, Stack<IAttributeFilter> filters) throws CoreException {
        IPath[] pathArr;
        int idx = this.m_paths.size();
        if (idx > 0) {
            pathArr = this.m_paths.toArray(new IPath[idx]);
            while (--idx >= 0) {
                pathArr[idx] = PerformManager.expandPath(local, pathArr[idx]);
            }
        } else {
            pathArr = Trivial.EMPTY_PATH_ARRAY;
        }
        return new PathGroup[]{new PathGroup(this.getExpandedBase(local), pathArr)};
    }
}

