/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.parser;

import org.eclipse.buckminster.core.common.parser.DocumentationHandler;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.parser.ActionsHandler;
import org.eclipse.buckminster.core.cspec.parser.ArtifactsHandler;
import org.eclipse.buckminster.core.cspec.parser.DependenciesHandler;
import org.eclipse.buckminster.core.cspec.parser.GeneratorsHandler;
import org.eclipse.buckminster.core.cspec.parser.GroupsHandler;
import org.eclipse.buckminster.core.cspec.parser.ICSpecBuilderSupport;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.InvalidSyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CSpecHandler
extends ExtensionAwareHandler
implements ICSpecBuilderSupport,
ChildPoppedListener {
    public static final String TAG = "cspec";
    private DocumentationHandler m_documentationHandler;
    private DependenciesHandler m_dependenciesHandler;
    private GeneratorsHandler m_generatorsHandler;
    private ArtifactsHandler m_artifactsHandler;
    private ActionsHandler m_actionsHandler;
    private GroupsHandler m_groupsHandler;
    private CSpecBuilder m_builder;

    public CSpecHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        if (child instanceof DocumentationHandler) {
            this.m_builder.setDocumentation(((DocumentationHandler)child).createDocumentation());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ChildHandler ch;
        if ("documentation".equals(localName)) {
            if (this.m_documentationHandler == null) {
                this.m_documentationHandler = new DocumentationHandler((AbstractHandler)this);
            }
            ch = this.m_documentationHandler;
        } else if ("dependencies".equals(localName)) {
            if (this.m_dependenciesHandler == null) {
                this.m_dependenciesHandler = new DependenciesHandler((AbstractHandler)this);
            }
            ch = this.m_dependenciesHandler;
        } else if ("generators".equals(localName)) {
            if (this.m_generatorsHandler == null) {
                this.m_generatorsHandler = new GeneratorsHandler((AbstractHandler)this);
            }
            ch = this.m_generatorsHandler;
        } else if ("artifacts".equals(localName)) {
            if (this.m_artifactsHandler == null) {
                this.m_artifactsHandler = new ArtifactsHandler((AbstractHandler)this);
            }
            ch = this.m_artifactsHandler;
        } else if ("actions".equals(localName)) {
            if (this.m_actionsHandler == null) {
                this.m_actionsHandler = new ActionsHandler((AbstractHandler)this);
            }
            ch = this.m_actionsHandler;
        } else if ("groups".equals(localName)) {
            if (this.m_groupsHandler == null) {
                this.m_groupsHandler = new GroupsHandler((AbstractHandler)this);
            }
            ch = this.m_groupsHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public final CSpec getCSpec() {
        return this.m_builder.createCSpec();
    }

    public final CSpecBuilder getCSpecBuilder() {
        return this.m_builder;
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        super.handleAttributes(attrs);
        this.m_builder = new CSpecBuilder();
        this.m_builder.setName(CSpecHandler.getOptionalStringValue((Attributes)attrs, (String)"name"));
        this.m_builder.setComponentTypeID(this.getComponentType(attrs));
        this.m_builder.setProjectInfo(this.getOptionalURLValue(attrs, "projectInfo"));
        this.m_builder.setShortDesc(CSpecHandler.getOptionalStringValue((Attributes)attrs, (String)"shortDesc"));
        try {
            this.m_builder.setVersion(VersionHelper.parseVersionAttributes(attrs));
        }
        catch (CoreException e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
        }
        String filter = CSpecHandler.getOptionalStringValue((Attributes)attrs, (String)"filter");
        if (filter != null) {
            try {
                this.m_builder.setFilter(FilterFactory.newInstance((String)filter));
            }
            catch (InvalidSyntaxException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
            }
        }
    }
}

