/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspecext.model;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IAction;
import org.eclipse.buckminster.core.cspec.IActionArtifact;
import org.eclipse.buckminster.core.cspec.IArtifact;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.GeneratorBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.TopLevelAttribute;
import org.eclipse.buckminster.core.cspecext.model.AlterAttribute;
import org.eclipse.buckminster.core.cspecext.model.AlterDependency;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpecExtension {
    public static final String TAG = "cspecExtension";
    public static final String ELEM_ALTER_ACTIONS = "alterActions";
    public static final String ELEM_ALTER_ARTIFACTS = "alterArtifacts";
    public static final String ELEM_ALTER_DEPENDENCIES = "alterDependencies";
    public static final String ELEM_ALTER_GROUPS = "alterGroups";
    private final ICSpecData m_base;
    private final Set<String> m_removedDependencies;
    private final Set<String> m_removedAttributes;
    private final Map<String, String> m_renamedAttributes;
    private final Map<String, AlterAttribute<? extends TopLevelAttribute>> m_alteredAttributes;
    private final Map<String, AlterDependency> m_alteredDependencies;

    public static <T> T overrideCheckNull(T a, T b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (b.toString().equalsIgnoreCase("null")) {
            return null;
        }
        return b;
    }

    public CSpecExtension(ICSpecData base, Set<String> removedDependencies, Map<String, AlterDependency> alteredDependencies, Set<String> removedAttributes, Map<String, String> renamedAttributes, Map<String, AlterAttribute<? extends TopLevelAttribute>> alteredAttributes) {
        this.m_base = base;
        this.m_removedDependencies = Utils.createUnmodifiableSet(removedDependencies);
        this.m_removedAttributes = Utils.createUnmodifiableSet(removedAttributes);
        this.m_renamedAttributes = Utils.createUnmodifiableMap(renamedAttributes);
        this.m_alteredAttributes = Utils.createUnmodifiableMap(alteredAttributes);
        this.m_alteredDependencies = Utils.createUnmodifiableMap(alteredDependencies);
    }

    public void alterCSpec(CSpecBuilder cspecBuilder) throws CoreException {
        for (String removedDep : this.m_removedDependencies) {
            cspecBuilder.getRequiredDependency(removedDep, null);
            cspecBuilder.removeDependency(removedDep);
        }
        for (AlterDependency alterDep : this.m_alteredDependencies.values()) {
            alterDep.alterDependency(cspecBuilder.getRequiredDependency(alterDep.getName(), alterDep.getComponentTypeID()));
        }
        Collection<? extends IComponentRequest> addedDeps = this.m_base.getDependencies();
        for (IComponentRequest iComponentRequest : addedDeps) {
            cspecBuilder.addDependency(iComponentRequest);
        }
        for (IGenerator iGenerator : this.m_base.getGeneratorList()) {
            GeneratorBuilder bld = cspecBuilder.createGeneratorBuilder();
            bld.initFrom(iGenerator);
            cspecBuilder.addGenerator(bld);
        }
        for (String string : this.m_removedAttributes) {
            cspecBuilder.getRequiredAttribute(string);
            cspecBuilder.removeAttribute(string);
        }
        for (Map.Entry<String, String> entry : this.m_renamedAttributes.entrySet()) {
            String oldName = entry.getKey();
            AttributeBuilder bld = cspecBuilder.getRequiredAttribute(oldName);
            bld.setName(entry.getValue());
            cspecBuilder.removeAttribute(oldName);
            cspecBuilder.addAttribute(bld);
        }
        for (AlterAttribute<? extends TopLevelAttribute> alterAttribute : this.m_alteredAttributes.values()) {
            alterAttribute.alterAttribute((TopLevelAttributeBuilder)cspecBuilder.getRequiredAttribute(alterAttribute.getName()));
        }
        Map<String, ? extends IAttribute> map = this.m_base.getAttributes();
        for (IAttribute iAttribute : map.values()) {
            TopLevelAttributeBuilder attrBld = iAttribute instanceof IActionArtifact ? cspecBuilder.createActionArtifactBuilder() : (iAttribute instanceof IAction ? cspecBuilder.createActionBuilder() : (iAttribute instanceof IArtifact ? cspecBuilder.createArtifactBuilder() : cspecBuilder.createGroupBuilder()));
            ((AttributeBuilder)attrBld).initFrom(iAttribute);
            cspecBuilder.addAttribute(attrBld);
        }
        cspecBuilder.setComponentTypeID(CSpecExtension.overrideCheckNull(cspecBuilder.getComponentTypeID(), this.m_base.getComponentTypeID()));
        cspecBuilder.setVersion(CSpecExtension.overrideCheckNull(cspecBuilder.getVersion(), this.m_base.getVersion()));
        Documentation documentation = cspecBuilder.getDocumentation();
        Documentation baseDoc = this.m_base.getDocumentation();
        cspecBuilder.setDocumentation(documentation == null ? baseDoc : documentation.merge(baseDoc));
    }

    public void alterTopElement(CSpecBuilder bld) throws CoreException {
        String ctype;
        Version extVersion = this.m_base.getVersion();
        if (extVersion != null) {
            bld.setVersion(extVersion);
        }
        if ((ctype = this.m_base.getComponentTypeID()) != null) {
            bld.setComponentTypeID(ctype);
        }
    }
}

