/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import org.eclipse.buckminster.core.helpers.ProgressStatistics;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressReporter
extends Thread {
    private final IProgressMonitor m_reporterMonitor;
    private final ProgressStatistics m_reporterProgress;
    private final String m_format;
    private final int m_timeout;
    private boolean m_running;

    public ProgressReporter(IProgressMonitor reporterMonitor, ProgressStatistics reporterProgress, String format, int timeout) {
        this.m_reporterMonitor = reporterMonitor;
        this.m_reporterProgress = reporterProgress;
        this.m_format = format;
        this.m_timeout = timeout;
        this.m_running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.m_running && !this.m_reporterMonitor.isCanceled()) {
            try {
                Thread.sleep(this.m_timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ProgressReporter progressReporter = this;
            synchronized (progressReporter) {
                if (this.m_running && this.m_reporterProgress.shouldReport()) {
                    this.m_reporterMonitor.subTask(String.format(this.m_format, this.m_reporterProgress.report()));
                }
            }
        }
    }

    public synchronized void stopReporting() {
        this.m_running = false;
        this.interrupt();
    }
}

