/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.eclipse.buckminster.core.common.model.IProperties;
import org.eclipse.buckminster.core.helpers.BMProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PropertiesWrapper
extends AbstractMap<String, String>
implements IProperties<String> {
    PropertiesWrapper() {
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String ? this.getProperties().getProperty((String)key) != null : false;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new BackedIterator<Map.Entry<String, String>>(PropertiesWrapper.this){

                    @Override
                    public Map.Entry<String, String> next() {
                        return new BackedEntry(this.nextKey());
                    }
                };
            }

            @Override
            public int size() {
                return PropertiesWrapper.this.size();
            }
        };
    }

    @Override
    public String get(Object key) {
        return key instanceof String ? this.getProperties().getProperty((String)key) : null;
    }

    @Override
    public Set<String> immutableKeySet() {
        return this.keySet();
    }

    @Override
    public boolean isMutable(String key) {
        return true;
    }

    @Override
    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return new BackedIterator<String>(PropertiesWrapper.this){

                    @Override
                    public String next() {
                        return this.nextKey();
                    }
                };
            }

            @Override
            public int size() {
                return PropertiesWrapper.this.size();
            }
        };
    }

    @Override
    public Set<String> mutableKeySet() {
        return this.keySet();
    }

    @Override
    public Set<String> overlayKeySet() {
        return this.getProperties().keySet();
    }

    @Override
    public String put(String key, String value) {
        return (String)this.getProperties().setProperty(key, value);
    }

    @Override
    public String put(String key, String value, boolean mutable) {
        if (!mutable) {
            throw new UnsupportedOperationException("put immutable");
        }
        return this.put(key, value);
    }

    @Override
    public void setMutable(String key, boolean mutable) throws UnsupportedOperationException {
        if (!mutable) {
            throw new UnsupportedOperationException("setMutable");
        }
    }

    @Override
    public int size() {
        int sz = 0;
        Enumeration<?> names = this.getProperties().propertyNames();
        try {
            while (true) {
                names.nextElement();
                ++sz;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return sz;
        }
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        BMProperties.store(this, out, comments);
    }

    @Override
    public boolean supportsMutability() {
        return false;
    }

    @Override
    public Collection<String> values() {
        return new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                return new BackedIterator<String>(PropertiesWrapper.this){

                    @Override
                    public String next() {
                        return PropertiesWrapper.this.getProperties().getProperty(this.nextKey());
                    }
                };
            }

            @Override
            public int size() {
                return PropertiesWrapper.this.size();
            }
        };
    }

    protected abstract Properties getProperties();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BackedEntry
    implements Map.Entry<String, String> {
        private final String m_key;

        public BackedEntry(String key) {
            this.m_key = key;
        }

        @Override
        public String getKey() {
            return this.m_key;
        }

        @Override
        public String getValue() {
            return PropertiesWrapper.this.getProperties().getProperty(this.m_key);
        }

        @Override
        public String setValue(String value) {
            return (String)PropertiesWrapper.this.getProperties().setProperty(this.m_key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class BackedIterator<X>
    implements Iterator<X> {
        private final Enumeration<?> m_names;

        BackedIterator() {
            this.m_names = PropertiesWrapper.this.getProperties().propertyNames();
        }

        @Override
        public boolean hasNext() {
            return this.m_names.hasMoreElements();
        }

        public String nextKey() {
            return (String)this.m_names.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

