/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.materializer;

import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.materializer.AbstractMaterializer;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class InstallerJob
extends WorkspaceJob {
    private final MaterializationContext m_context;
    private final boolean m_propagateStatus;

    public InstallerJob(MaterializationContext ctx, boolean propagateStatus) throws CoreException {
        super(Messages.InstallerJob_Installing);
        this.m_context = ctx;
        this.m_propagateStatus = propagateStatus;
        this.setSystem(false);
        this.setUser(true);
        this.setPriority(30);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 1000);
        BillOfMaterials bom = this.m_context.getBillOfMaterials();
        try {
            try {
                AbstractMaterializer.performInstallActions(bom, this.m_context, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            }
            catch (CoreException e) {
                this.m_context.addRequestStatus(bom.getRequest(), e.getStatus());
                if (this.m_propagateStatus) {
                    CorePlugin.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
                }
                monitor.done();
                if (this.m_propagateStatus) {
                    this.m_context.emitWarningAndErrorTags();
                }
            }
        }
        finally {
            monitor.done();
            if (this.m_propagateStatus) {
                this.m_context.emitWarningAndErrorTags();
            }
        }
        return Status.OK_STATUS;
    }
}

