/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.util.List;
import java.util.Set;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorNode
extends BOMNode {
    public static final String ATTR_ATTRIBUTE = "attribute";
    public static final String ATTR_COMPONENT = "component";
    public static final String ATTR_GENERATES = "generates";
    public static final String ATTR_GENERATES_TYPE = "generatesType";
    public static final String ATTR_GENERATES_VERSION = "generatesType";
    public static final String ATTR_DECLARING_CSPEC_ID = "declaringCSpecId";
    public static final String TAG = "generatorNode";
    private final String m_attribute;
    private final String m_component;
    private final IComponentIdentifier m_generates;
    private final CSpec m_declaringCSpec;

    public GeneratorNode(CSpec declaringCSpec, IGenerator generator) {
        this.m_declaringCSpec = declaringCSpec;
        this.m_component = generator.getComponent();
        this.m_attribute = generator.getAttribute();
        this.m_generates = generator.getGeneratedIdentifier();
    }

    public GeneratorNode(CSpec declaringCSpec, String component, String attribute, IComponentIdentifier generates) {
        this.m_declaringCSpec = declaringCSpec;
        this.m_component = component;
        this.m_attribute = attribute;
        this.m_generates = generates;
    }

    public GeneratorNode(CSpec declaringCSpec, String component, String attribute, String generates) {
        this(declaringCSpec, component, attribute, new ComponentIdentifier(generates, null, null));
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public String getComponent() {
        return this.m_component;
    }

    public CSpec getDeclaringCSpec() {
        return this.m_declaringCSpec;
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Deprecated
    public String getGenerates() {
        return this.m_generates.getName();
    }

    public IComponentIdentifier getGeneratesId() {
        return this.m_generates;
    }

    @Override
    public QualifiedDependency getQualifiedDependency() {
        return new QualifiedDependency(this.getRequest(), null);
    }

    @Override
    public ComponentRequest getRequest() {
        VersionRange range = null;
        if (this.m_generates.getVersion() != null) {
            range = new VersionRange(this.m_generates.getVersion(), true, this.m_generates.getVersion(), false);
        }
        return new ComponentRequest(this.m_generates.getName(), this.m_generates.getComponentTypeID(), range);
    }

    @Override
    public String getViewName() throws CoreException {
        return String.valueOf(this.getRequest().getViewName()) + ":generated";
    }

    @Override
    public boolean isFullyResolved(ComponentQuery query) throws CoreException {
        return true;
    }

    protected void addAttributes(AttributesImpl attrs) {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_DECLARING_CSPEC_ID, (String)this.m_declaringCSpec.getId().toString());
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ATTRIBUTE, (String)this.m_attribute);
        if (this.m_component != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT, (String)this.m_component);
        }
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_GENERATES, (String)this.m_generates.getName());
        if (this.m_generates.getComponentTypeID() != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"generatesType", (String)this.m_generates.getComponentTypeID());
        }
        if (this.m_generates.getVersion() != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"generatesType", (String)this.m_generates.getVersion().toString());
        }
    }

    @Override
    void addMaterializationCandidates(RMContext context, List<Resolution> resolutions, ComponentQuery query, MaterializationSpec mspec, Set<Resolution> perused) throws CoreException {
    }
}

