/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.model;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNodeException;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvedNode
extends BOMNode {
    public static final String ELEM_ATTRIBUTE = "attribute";
    public static final String TAG = "unresolvedNode";
    private final QualifiedDependency m_dependency;

    public UnresolvedNode(QualifiedDependency dependency) {
        this.m_dependency = dependency;
    }

    @Override
    public void addUnresolved(List<ComponentRequest> unresolved, Set<Resolution> skipThese) {
        unresolved.add(this.m_dependency.getRequest());
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public QualifiedDependency getQualifiedDependency() {
        return this.m_dependency;
    }

    @Override
    public ComponentRequest getRequest() {
        return this.m_dependency.getRequest();
    }

    @Override
    public String getViewName() throws CoreException {
        return String.valueOf(this.getRequest().getViewName()) + ":unresolved";
    }

    protected void emitElements(ContentHandler receiver, String namespace, String prefix) throws SAXException {
        ComponentRequest request = this.m_dependency.getRequest();
        request.toSax(receiver, namespace, prefix, request.getDefaultTag());
        Set<String> names = this.m_dependency.getAttributeNames();
        int top = names.size();
        if (top > 0) {
            Object[] attrNames = names.toArray(new String[top]);
            Arrays.sort(attrNames);
            String qName = Utils.makeQualifiedName((String)prefix, (String)ELEM_ATTRIBUTE);
            int idx = 0;
            while (idx < top) {
                AttributesImpl attrs = new AttributesImpl();
                Utils.addAttribute((AttributesImpl)attrs, (String)"name", (String)attrNames[idx]);
                receiver.startElement(namespace, ELEM_ATTRIBUTE, qName, attrs);
                receiver.endElement(namespace, ELEM_ATTRIBUTE, qName);
                ++idx;
            }
        }
    }

    @Override
    void addMaterializationCandidates(RMContext context, List<Resolution> resolutions, ComponentQuery query, MaterializationSpec mspec, Set<Resolution> perused) throws CoreException {
        try {
            ComponentRequest request = this.getRequest();
            if (!(request.isOptional() || query.skipComponent(request, context) || mspec.isExcluded(request))) {
                throw new UnresolvedNodeException(request);
            }
        }
        catch (CoreException e) {
            if (!context.isContinueOnError()) {
                throw e;
            }
            context.addRequestStatus(this.getRequest(), e.getStatus());
        }
    }
}

