/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.mspec.IMaterializationDirective;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MaterializationDirectiveBuilder
implements IMaterializationDirective {
    private Documentation m_documentation;
    private IPath m_installLocation;
    private IPath m_workspaceLocation;
    private String m_materializerID;
    private final HashMap<String, String> m_properties = new HashMap();
    private ConflictResolution m_conflictResolution;
    private int m_maxParallelJobs = -1;

    public void clear() {
        this.m_maxParallelJobs = -1;
        this.m_installLocation = null;
        this.m_workspaceLocation = null;
        this.m_materializerID = null;
        this.m_conflictResolution = null;
        this.m_documentation = null;
        this.m_properties.clear();
    }

    @Override
    public ConflictResolution getConflictResolution() {
        return this.m_conflictResolution;
    }

    @Override
    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    @Override
    public IPath getInstallLocation() {
        return this.m_installLocation;
    }

    @Override
    public String getMaterializerID() {
        return this.m_materializerID;
    }

    @Override
    public int getMaxParallelJobs() {
        return this.m_maxParallelJobs;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    @Override
    public IPath getWorkspaceLocation() {
        return this.m_workspaceLocation;
    }

    public void initFrom(IMaterializationDirective md) {
        this.clear();
        this.m_documentation = md.getDocumentation();
        this.m_installLocation = md.getInstallLocation();
        this.m_workspaceLocation = md.getWorkspaceLocation();
        this.m_materializerID = md.getMaterializerID();
        this.m_maxParallelJobs = md.getMaxParallelJobs();
        this.m_conflictResolution = md.getConflictResolution();
        this.m_properties.putAll(md.getProperties());
    }

    public void setConflictResolution(ConflictResolution whenPresent) {
        this.m_conflictResolution = whenPresent;
    }

    public void setDocumentation(Documentation documentation) {
        this.m_documentation = documentation;
    }

    public void setInstallLocation(IPath installLocation) {
        this.m_installLocation = installLocation;
    }

    public void setMaterializerID(String materializerID) {
        this.m_materializerID = materializerID;
    }

    public void setMaxParallelJobs(int maxParallelJobs) {
        this.m_maxParallelJobs = maxParallelJobs;
    }

    public void setWorkspaceLocation(IPath workspaceLocation) {
        this.m_workspaceLocation = workspaceLocation;
    }
}

