/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.model;

import java.util.Map;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.mspec.IMaterializationDirective;
import org.eclipse.buckminster.core.mspec.builder.MaterializationDirectiveBuilder;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MaterializationDirective
extends AbstractSaxableElement
implements IMaterializationDirective {
    public static final String ATTR_INSTALL_LOCATION = "installLocation";
    public static final String ATTR_WORKSPACE_LOCATION = "workspaceLocation";
    public static final String ATTR_MATERIALIZER = "materializer";
    public static final String ATTR_CONFLICT_RESOLUTION = "conflictResolution";
    public static final String ATTR_MAX_PARALLEL_JOBS = "maxParallelJobs";
    private final int m_maxParallelJobs;
    private final Map<String, String> m_properties;
    private final IPath m_installLocation;
    private final IPath m_workspaceLocation;
    private final String m_materializer;
    private final ConflictResolution m_conflictResolution;
    private final Documentation m_documentation;

    public MaterializationDirective(MaterializationDirectiveBuilder builder) {
        this.m_documentation = builder.getDocumentation();
        IPath tmp = builder.getInstallLocation();
        this.m_installLocation = tmp == null ? null : tmp.addTrailingSeparator();
        tmp = builder.getWorkspaceLocation();
        this.m_workspaceLocation = tmp == null ? null : tmp.addTrailingSeparator();
        this.m_materializer = builder.getMaterializerID();
        this.m_conflictResolution = builder.getConflictResolution();
        this.m_properties = ExpandingProperties.createUnmodifiableProperties(builder.getProperties());
        this.m_maxParallelJobs = builder.getMaxParallelJobs();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.m_installLocation != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_INSTALL_LOCATION, (String)this.m_installLocation.toPortableString());
        }
        if (this.m_workspaceLocation != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_WORKSPACE_LOCATION, (String)this.m_workspaceLocation.toPortableString());
        }
        if (this.m_materializer != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MATERIALIZER, (String)this.m_materializer);
        }
        if (this.m_conflictResolution != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_CONFLICT_RESOLUTION, (String)this.m_conflictResolution.name());
        }
        if (this.m_maxParallelJobs != -1) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MAX_PARALLEL_JOBS, (String)Integer.toString(this.m_maxParallelJobs));
        }
    }

    protected void emitElements(ContentHandler receiver, String namespace, String prefix) throws SAXException {
        if (this.m_documentation != null) {
            this.m_documentation.toSax(receiver, namespace, prefix, this.m_documentation.getDefaultTag());
        }
        SAXEmitter.emitProperties(receiver, this.m_properties, namespace, prefix, true, false);
    }

    @Override
    public ConflictResolution getConflictResolution() {
        return this.m_conflictResolution;
    }

    @Override
    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    @Override
    public IPath getInstallLocation() {
        return this.m_installLocation;
    }

    @Override
    public String getMaterializerID() {
        return this.m_materializer;
    }

    @Override
    public int getMaxParallelJobs() {
        return this.m_maxParallelJobs;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    @Override
    public IPath getWorkspaceLocation() {
        return this.m_workspaceLocation;
    }
}

