/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.parser;

import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.parser.AbstractParser;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensionAwareHandler
extends ChildHandler {
    protected ExtensionAwareHandler(AbstractHandler parent) {
        super(parent);
    }

    public <H extends ChildHandler> H createContentHandler(Class<H> instanceClass, String namespace, Attributes attrs) throws SAXException {
        String xsiType = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        return ((AbstractParser)this.getTopHandler()).createContentHandler((AbstractHandler)this, instanceClass, namespace, xsiType);
    }

    protected String getComponentType(Attributes attrs) throws SAXException {
        String tmp = ExtensionAwareHandler.getOptionalStringValue((Attributes)attrs, (String)"componentType");
        if (tmp == null && (tmp = ExtensionAwareHandler.getOptionalStringValue((Attributes)attrs, (String)"category")) != null) {
            this.logAttributeDeprecation(this.getTAG(), "category", "componentType");
            if (tmp.equals("plugin")) {
                tmp = "osgi.bundle";
            } else if (tmp.equals("feature")) {
                tmp = "eclipse.feature";
            }
        }
        return tmp;
    }

    protected void logAttributeDeprecation(String elementName, String attrName, String useInstead) {
        Locator locator = this.getDocumentLocator();
        this.warningOnce(String.format(NLS.bind((String)Messages.Use_of_deprecated_attribute_0_1_Use_attribute_2_instead_3_line_4, (Object[])new Object[]{elementName, attrName, useInstead, locator.getSystemId(), new Integer(locator.getLineNumber())}), new Object[0]));
    }

    protected void logAttributeIgnored(String elementName, String attrName, String useInstead) {
        Locator locator = this.getDocumentLocator();
        this.warningOnce(String.format(NLS.bind((String)Messages.Use_of_deprecated_attribute_0_1_was_ignored_Use_attribute_2_instead_3_line_4, (Object[])new Object[]{elementName, attrName, useInstead, locator.getSystemId(), new Integer(locator.getLineNumber())}), new Object[0]));
    }

    protected void logAttributeValueDeprecation(String elementName, String attrName, String oldValue, String useInstead) {
        Locator locator = this.getDocumentLocator();
        this.warningOnce(String.format(NLS.bind((String)Messages.Use_of_deprecated_value_for_attribute_0_1_Was_2_should_be_3_4_line_5, (Object[])new Object[]{elementName, attrName, oldValue, useInstead, locator.getSystemId(), new Integer(locator.getLineNumber())}), new Object[0]));
    }

    protected void logElementDeprecated(String elementName, String useInstead) {
        Locator locator = this.getDocumentLocator();
        this.warningOnce(String.format(NLS.bind((String)Messages.Use_of_deprecated_element_0_Use_element_1_instead_2_line_3, (Object[])new Object[]{elementName, useInstead, locator.getSystemId(), new Integer(locator.getLineNumber())}), new Object[0]));
    }

    protected void logElementIgnored(String elementName) {
        Locator locator = this.getDocumentLocator();
        this.warningOnce(String.format(NLS.bind((String)Messages.Use_of_deprecated_element_0_was_ignored_1_line_2, (Object[])new Object[]{elementName, locator.getSystemId(), new Integer(locator.getLineNumber())}), new Object[0]));
    }

    protected void warningOnce(String warning) {
        ((AbstractParser)this.getTopHandler()).warningOnce(warning);
    }
}

