/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.site;

import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.ExtendedSite;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SaxableSite
extends AbstractSaxableElement
implements ISaxable {
    public static final String TAG = "site";
    public static final String ATTR_ASSOCIATE_SITES_URL = "associateSitesURL";
    public static final String ATTR_MIRRORS_URL = "mirrorsURL";
    private final Site m_site;
    private final String m_mirrorsURL;
    private final String m_associateSitesURL;

    private static void addOptionalAttribute(AttributesImpl attrs, String name, String value) {
        if (value != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)name, (String)value);
        }
    }

    private static void writeArchives(ContentHandler handler, ArchiveReferenceModel[] archiveReferenceModels) throws SAXException {
        int top = archiveReferenceModels.length;
        int idx = 0;
        while (idx < top) {
            ArchiveReferenceModel sm = archiveReferenceModels[idx];
            AttributesImpl attrs = new AttributesImpl();
            Utils.addAttribute((AttributesImpl)attrs, (String)"path", (String)sm.getPath());
            Utils.addAttribute((AttributesImpl)attrs, (String)"url", (String)sm.getURLString());
            handler.startElement("", "", "archive", attrs);
            handler.endElement("", "", "archive");
            ++idx;
        }
    }

    private static void writeCategories(ContentHandler handler, CategoryModel[] categoryModels) throws SAXException {
        int top = categoryModels.length;
        int idx = 0;
        while (idx < top) {
            String label;
            CategoryModel cm = categoryModels[idx];
            AttributesImpl attrs = new AttributesImpl();
            String name = Trivial.trim((String)cm.getName());
            if (name != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"name", (String)name);
            }
            if ((label = Trivial.trim((String)cm.getLabelNonLocalized())) != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"label", (String)label);
            }
            handler.startElement("", "", "category-def", attrs);
            URLEntryModel desc = cm.getDescriptionModel();
            if (desc != null) {
                SaxableSite.writeDescription(handler, desc);
            }
            handler.endElement("", "", "category-def");
            ++idx;
        }
    }

    private static void writeDescription(ContentHandler handler, URLEntryModel urlEntryModel) throws SAXException {
        String url = Trivial.trim((String)urlEntryModel.getURLString());
        String text = Trivial.trim((String)urlEntryModel.getAnnotationNonLocalized());
        if (url != null || text != null) {
            Attributes attrs;
            if (url == null) {
                attrs = ISaxableElement.EMPTY_ATTRIBUTES;
            } else {
                attrs = new AttributesImpl();
                Utils.addAttribute((AttributesImpl)((AttributesImpl)attrs), (String)"url", (String)url);
            }
            handler.startElement("", "", "description", attrs);
            if (text != null) {
                handler.characters(text.toCharArray(), 0, text.length());
            }
            handler.endElement("", "", "description");
        }
    }

    private static void writeFeatures(ContentHandler handler, SiteFeatureReferenceModel[] featureReferenceModels) throws SAXException {
        int top = featureReferenceModels.length;
        int idx = 0;
        while (idx < top) {
            SiteFeatureReferenceModel sm = featureReferenceModels[idx];
            AttributesImpl attrs = new AttributesImpl();
            Utils.addAttribute((AttributesImpl)attrs, (String)"url", (String)sm.getURLString());
            Utils.addAttribute((AttributesImpl)attrs, (String)"id", (String)sm.getFeatureIdentifier());
            SaxableSite.addOptionalAttribute(attrs, "version", sm.getFeatureVersion());
            SaxableSite.addOptionalAttribute(attrs, "label", sm.getLabelNonLocalized());
            SaxableSite.addOptionalAttribute(attrs, "type", sm.getType());
            SaxableSite.addOptionalAttribute(attrs, "os", sm.getOS());
            SaxableSite.addOptionalAttribute(attrs, "ws", sm.getWS());
            SaxableSite.addOptionalAttribute(attrs, "nl", sm.getNL());
            SaxableSite.addOptionalAttribute(attrs, "arch", sm.getOSArch());
            SaxableSite.addOptionalAttribute(attrs, "patch", sm.getPatch());
            handler.startElement("", "", "feature", attrs);
            String[] categoryNames = sm.getCategoryNames();
            int cn = 0;
            while (cn < categoryNames.length) {
                AttributesImpl nameAttr = new AttributesImpl();
                Utils.addAttribute((AttributesImpl)nameAttr, (String)"name", (String)categoryNames[cn]);
                handler.startElement("", "", "category", nameAttr);
                handler.endElement("", "", "category");
                ++cn;
            }
            handler.endElement("", "", "feature");
            ++idx;
        }
    }

    public SaxableSite(Site site) {
        this(site, null, null);
    }

    public SaxableSite(Site site, String mirrorsURL, String associateSitesURL) {
        this.m_site = site;
        this.m_mirrorsURL = mirrorsURL;
        this.m_associateSitesURL = associateSitesURL;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public Site getSite() {
        return this.m_site;
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        this.toSax(receiver, "", "", TAG);
        receiver.endDocument();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        String urlStr;
        String type = this.m_site.getType();
        if (type != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"type", (String)type);
        }
        if ((urlStr = this.m_site.getLocationURLString()) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"url", (String)urlStr);
        }
        if (this.m_mirrorsURL != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MIRRORS_URL, (String)this.m_mirrorsURL);
        }
        if (this.m_associateSitesURL != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ASSOCIATE_SITES_URL, (String)this.m_associateSitesURL);
        }
        if (this.m_site instanceof ExtendedSite) {
            String[] availableLocales;
            String digestURL;
            ExtendedSite extSite = (ExtendedSite)this.m_site;
            if (extSite.supportsPack200()) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"pack200", (String)"true");
            }
            if ((digestURL = Trivial.trim((String)extSite.getDigestURL())) != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"digestURL", (String)digestURL);
            }
            if ((availableLocales = extSite.getAvailableLocals()) != null) {
                StringBuilder bld = new StringBuilder();
                TextUtils.concat(bld, availableLocales, ",");
                if (bld.length() > 0) {
                    Utils.addAttribute((AttributesImpl)attrs, (String)"availableLocales", (String)bld.toString());
                }
            }
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        URLEntryModel description = this.m_site.getDescriptionModel();
        if (description != null) {
            SaxableSite.writeDescription(handler, description);
        }
        SaxableSite.writeFeatures(handler, this.m_site.getFeatureReferenceModels());
        SaxableSite.writeCategories(handler, this.m_site.getCategoryModels());
        SaxableSite.writeArchives(handler, this.m_site.getArchiveReferenceModels());
    }
}

