/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.buckminster.core.version.MissingVersionTypeException;
import org.eclipse.buckminster.core.version.VersionType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.provisional.p2.core.FormatException;
import org.eclipse.equinox.internal.provisional.p2.core.VersionFormat;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHelper {
    static final String VERSION_TYPES_POINT = "org.eclipse.buckminster.core.versionTypes";
    private static final HashMap<String, VersionType> s_knownTypes = new HashMap();
    private static SimpleDateFormat s_timestampFormat = new SimpleDateFormat("yyyyMMdd'.'HHmmss");
    private static SimpleDateFormat s_dateFormat = new SimpleDateFormat("yyyyMMdd");

    static {
        try {
            org.eclipse.equinox.internal.provisional.p2.core.Version.parseVersion((String)"1.0.0");
            IExtensionRegistry exReg = Platform.getExtensionRegistry();
            IConfigurationElement[] elems = exReg.getConfigurationElementsFor(VERSION_TYPES_POINT);
            int idx = elems.length;
            block2: while (--idx >= 0) {
                IConfigurationElement elem = elems[idx];
                String format = elem.getAttribute("format");
                String id = elem.getAttribute("id");
                VersionType vt = s_knownTypes.get(format);
                if (vt != null) {
                    String[] labels = vt.getLabels();
                    int top = labels.length;
                    int ldx = 0;
                    while (ldx < top) {
                        if (labels[ldx].equals(id)) continue block2;
                        ++ldx;
                    }
                    String[] newLabels = new String[top + 1];
                    System.arraycopy(labels, 0, newLabels, 0, top);
                    newLabels[top] = id;
                    vt = new VersionType(VersionFormat.compile((String)format), newLabels);
                } else {
                    vt = new VersionType(VersionFormat.compile((String)format), id);
                }
                s_knownTypes.put(format, vt);
            }
        }
        catch (FormatException e) {
            throw new ExceptionInInitializerError(e);
        }
        TimeZone utc = TimeZone.getTimeZone("UTC");
        s_timestampFormat.setTimeZone(utc);
        s_dateFormat.setTimeZone(utc);
    }

    public static VersionRange createRange(String versionTypeLabel, String rangeString) throws MissingVersionTypeException {
        return VersionHelper.createRange(VersionHelper.getVersionType(versionTypeLabel), rangeString);
    }

    public static VersionRange createRange(VersionFormat versionFormat, String rangeString) {
        if (rangeString == null) {
            return null;
        }
        if (versionFormat == null || versionFormat.equals((Object)VersionFormat.OSGI_FORMAT)) {
            return new VersionRange(rangeString);
        }
        StringBuffer bld = new StringBuffer();
        versionFormat.toString(bld);
        bld.append(':');
        bld.append(rangeString);
        return new VersionRange(bld.toString());
    }

    public static VersionRange createRange(VersionType versionType, String rangeString) {
        return VersionHelper.createRange(versionType == null ? null : versionType.getFormat(), rangeString);
    }

    public static org.eclipse.equinox.internal.provisional.p2.core.Version createVersion(String versionTypeLabel, String versionString) throws MissingVersionTypeException {
        return VersionHelper.createVersion(VersionHelper.getVersionType(versionTypeLabel), versionString);
    }

    public static org.eclipse.equinox.internal.provisional.p2.core.Version createVersion(VersionFormat versionFormat, String versionString) {
        if (versionString == null) {
            return null;
        }
        if ((versionString = Trivial.trim((String)versionString)) == null) {
            return null;
        }
        if (versionFormat == null) {
            versionFormat = VersionFormat.OSGI_FORMAT;
        }
        return versionFormat.parse(versionString);
    }

    public static org.eclipse.equinox.internal.provisional.p2.core.Version createVersion(VersionType versionType, String versionString) {
        return VersionHelper.createVersion(versionType == null ? null : versionType.getFormat(), versionString);
    }

    public static boolean equalsUnqualified(org.eclipse.equinox.internal.provisional.p2.core.Version a, org.eclipse.equinox.internal.provisional.p2.core.Version b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals((Object)b) || a.isOSGiCompatible() && b.isOSGiCompatible() && a.getMajor() == b.getMajor() && a.getMinor() == b.getMinor() && a.getMicro() == b.getMicro();
    }

    public static VersionRange exactRange(Version v) {
        return v == null ? null : VersionHelper.exactRange(org.eclipse.equinox.internal.provisional.p2.core.Version.parseVersion((String)v.toString()));
    }

    public static VersionRange exactRange(org.eclipse.equinox.internal.provisional.p2.core.Version v) {
        return v == null ? null : new VersionRange(v, true, v, true);
    }

    public static String getHumanReadable(org.eclipse.equinox.internal.provisional.p2.core.Version version) {
        if (version == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        VersionHelper.getOriginal(version, buf);
        if (!VersionFormat.OSGI_FORMAT.equals((Object)version.getFormat())) {
            buf.append('#');
            buf.append(VersionHelper.getVersionType(version).getId());
        }
        return buf.toString();
    }

    public static String getHumanReadable(VersionRange range) {
        if (range == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (VersionFormat.OSGI_FORMAT.equals((Object)range.getFormat())) {
            range.toString(buf);
        } else {
            if (range.getMaximum().equals((Object)org.eclipse.equinox.internal.provisional.p2.core.Version.MAX_VERSION) && range.getIncludeMaximum()) {
                VersionHelper.getOriginal(range.getMinimum(), buf);
            } else {
                buf.append(range.getIncludeMinimum() ? (char)'[' : '(');
                VersionHelper.getOriginal(range.getMinimum(), buf);
                buf.append(',');
                VersionHelper.getOriginal(range.getMaximum(), buf);
                buf.append(range.getIncludeMaximum() ? (char)']' : ')');
            }
            buf.append('#');
            buf.append(VersionHelper.getVersionType(range).getId());
        }
        return buf.toString();
    }

    public static List<VersionType> getKnownTypes() {
        ArrayList<VersionType> knownTypes = new ArrayList<VersionType>(s_knownTypes.values());
        Collections.sort(knownTypes, new Comparator<VersionType>(){

            @Override
            public int compare(VersionType o1, VersionType o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return knownTypes;
    }

    public static String getOriginal(org.eclipse.equinox.internal.provisional.p2.core.Version version) {
        if (version == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        VersionHelper.getOriginal(version, sb);
        return sb.toString();
    }

    public static void getOriginal(org.eclipse.equinox.internal.provisional.p2.core.Version version, StringBuffer sb) {
        if (version == null) {
            return;
        }
        String orig = version.getOriginal();
        if (orig != null) {
            sb.append(orig);
        } else if (VersionFormat.OSGI_FORMAT.equals((Object)version.getFormat())) {
            version.toString(sb);
        } else {
            version.rawToString(sb, false);
        }
    }

    public static VersionType getVersionType(String id) throws MissingVersionTypeException {
        if (id == null) {
            id = "OSGi";
        }
        for (VersionType vt : s_knownTypes.values()) {
            String[] stringArray = vt.getLabels();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray[n2];
                if (label.equals(id)) {
                    return vt;
                }
                ++n2;
            }
        }
        throw new MissingVersionTypeException(id);
    }

    public static VersionType getVersionType(org.eclipse.equinox.internal.provisional.p2.core.Version version) {
        VersionFormat format = version.getFormat();
        if (format == null) {
            format = VersionFormat.RAW_FORMAT;
        }
        return VersionHelper.getVersionType(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionType getVersionType(VersionFormat format) {
        if (format == null) {
            return null;
        }
        String fmtString = format.toString();
        fmtString = fmtString.substring(7, fmtString.length() - 1);
        HashMap<String, VersionType> hashMap = s_knownTypes;
        synchronized (hashMap) {
            VersionType vt = s_knownTypes.get(fmtString);
            if (vt == null) {
                vt = new VersionType(format, fmtString);
                s_knownTypes.put(fmtString, vt);
            }
            return vt;
        }
    }

    public static VersionType getVersionType(VersionRange range) {
        VersionFormat format = range.getFormat();
        if (format == null) {
            format = VersionFormat.RAW_FORMAT;
        }
        return VersionHelper.getVersionType(format);
    }

    public static VersionRange greaterOrEqualRange(org.eclipse.equinox.internal.provisional.p2.core.Version version) {
        return version == null ? null : new VersionRange(version.toString());
    }

    public static org.eclipse.equinox.internal.provisional.p2.core.Version parseVersion(String versionStr) {
        org.eclipse.equinox.internal.provisional.p2.core.Version version = org.eclipse.equinox.internal.provisional.p2.core.Version.parseVersion((String)versionStr);
        if (version.equals((Object)org.eclipse.equinox.internal.provisional.p2.core.Version.emptyVersion)) {
            version = null;
        }
        return version;
    }

    public static org.eclipse.equinox.internal.provisional.p2.core.Version parseVersionAttributes(Attributes attrs) throws CoreException {
        String tmp = AbstractHandler.getOptionalStringValue((Attributes)attrs, (String)"version");
        if (tmp == null) {
            return null;
        }
        try {
            String type = AbstractHandler.getOptionalStringValue((Attributes)attrs, (String)"versionType");
            return type == null ? VersionHelper.parseVersion(tmp) : VersionHelper.createVersion(type, tmp);
        }
        catch (IllegalArgumentException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static VersionRange parseVersionRangeAttributes(Attributes attrs) throws CoreException {
        return VersionHelper.parseVersionRangeAttributes(attrs, "versionDesignator", "versionType");
    }

    public static VersionRange parseVersionRangeAttributes(Attributes attrs, String versionAttr, String versionTypeAttr) throws CoreException {
        String tmp = AbstractHandler.getOptionalStringValue((Attributes)attrs, (String)versionAttr);
        if (tmp == null) {
            return null;
        }
        try {
            String type = AbstractHandler.getOptionalStringValue((Attributes)attrs, (String)versionTypeAttr);
            return type == null ? new VersionRange(tmp) : VersionHelper.createRange(type, tmp);
        }
        catch (IllegalArgumentException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static org.eclipse.equinox.internal.provisional.p2.core.Version replaceQualifier(org.eclipse.equinox.internal.provisional.p2.core.Version version, String qualifier) {
        if (version == null || !version.isOSGiCompatible()) {
            return version;
        }
        String stringForm = version.toString();
        String qual = version.getQualifier();
        if (qual != null) {
            stringForm = qualifier != null ? String.valueOf(stringForm.substring(0, stringForm.length() - qual.length())) + qualifier : stringForm.substring(0, stringForm.length() - (qual.length() + 1));
        } else if (qualifier != null) {
            stringForm = String.valueOf(stringForm) + '.' + qualifier;
        }
        return version.getFormat().parse(stringForm);
    }

    public static Object toTimestampString(Date timestamp) {
        return s_timestampFormat.format(timestamp);
    }
}

