/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cvspkg.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Stack;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.cvspkg.Messages;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class FileSystemCopier
implements ICVSResourceVisitor {
    public static final String CVS_DIRNAME = "CVS";
    public static final String REPOSITORY = "Repository";
    public static final String ROOT = "Root";
    public static final String STATIC = "Entries.Static";
    public static final String TAG = "Tag";
    public static final String ENTRIES = "Entries";
    private final IPath m_fsRoot;
    private final ICVSFolder m_cvsRoot;
    private final IProgressMonitor m_monitor;
    private final Stack<FolderInfo> m_currentPath = new Stack();

    private static IPath createDirectory(IPath parentFolder) throws CVSException {
        File dir = parentFolder.toFile();
        if (!dir.mkdirs() && !dir.exists()) {
            throw new CVSException(NLS.bind((String)Messages.unable_to_create_directory_0, (Object)dir));
        }
        return parentFolder;
    }

    private static void writeLines(IPath parentFolder, String metaFile, String ... lines) throws CVSException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(parentFolder.append(metaFile).toFile());
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    out.println(line);
                    ++n2;
                }
            }
            catch (FileNotFoundException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close((Closeable)out);
    }

    public FileSystemCopier(ICVSFolder cvsRoot, IPath fsRoot, IProgressMonitor monitor) throws CVSException {
        this.m_cvsRoot = cvsRoot;
        this.m_fsRoot = fsRoot;
        this.m_monitor = monitor;
        monitor.beginTask(null, -1);
    }

    public void done() throws CVSException {
        while (!this.m_currentPath.isEmpty()) {
            this.visitFolderEnd();
        }
        this.m_monitor.done();
    }

    public void visitFile(ICVSFile file) throws CVSException {
        this.checkFolderEnd(file.getParent());
        FolderInfo fi = this.m_currentPath.peek();
        fi.assertCreated();
        FileOutputStream out = null;
        InputStream in = null;
        File osFile = fi.getPath().append(file.getName()).toFile();
        try {
            try {
                out = new FileOutputStream(osFile);
                in = file.getContents();
                FileUtils.copyFile((InputStream)in, (OutputStream)out, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)this.m_monitor, (int)10));
            }
            catch (IOException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            IOUtils.close((Closeable)out);
            throw throwable;
        }
        IOUtils.close((Closeable)in);
        IOUtils.close((Closeable)out);
        ResourceSyncInfo syncInfo = file.getSyncInfo();
        Date timestamp = syncInfo.getTimeStamp();
        if (timestamp != null) {
            osFile.setLastModified(timestamp.getTime());
        } else {
            MutableResourceSyncInfo mrsi = syncInfo.cloneMutable();
            mrsi.setTimeStamp(new Date(osFile.lastModified()));
            syncInfo = mrsi;
        }
        fi.addEntry(syncInfo.getBytes());
    }

    public void visitFolder(ICVSFolder folder) throws CVSException {
        this.checkFolderEnd(folder);
        this.m_currentPath.push(new FolderInfo(folder, this.m_fsRoot.append(folder.getRelativePath(this.m_cvsRoot))));
    }

    private void checkFolderEnd(ICVSFolder folder) throws CVSException {
        if (!this.m_currentPath.isEmpty()) {
            IPath fullPath = this.m_fsRoot.append(folder.getRelativePath(this.m_cvsRoot));
            while (!this.m_currentPath.peek().isPrefixOf(fullPath)) {
                this.visitFolderEnd();
            }
        }
    }

    private void visitFolderEnd() throws CVSException {
        FolderInfo info = this.m_currentPath.pop();
        if (info.isEmpty()) {
            return;
        }
        info.writeSync();
        MonitorUtils.worked((IProgressMonitor)this.m_monitor, (int)5);
        if (!this.m_currentPath.isEmpty()) {
            this.m_currentPath.peek().addEntry(info.getFolderSyncBytes());
        }
    }

    private static class FolderInfo {
        private final IPath m_path;
        private final ArrayList<byte[]> m_entries;
        private final ICVSFolder m_folder;
        private boolean m_isCreated;

        FolderInfo(ICVSFolder folder, IPath path) throws CVSException {
            this.m_folder = folder;
            this.m_entries = new ArrayList();
            this.m_path = path;
        }

        void addEntry(byte[] entry) {
            this.m_entries.add(entry);
        }

        void assertCreated() throws CVSException {
            if (!this.m_isCreated) {
                FileSystemCopier.createDirectory(this.m_path);
                this.m_isCreated = true;
            }
        }

        byte[] getFolderSyncBytes() throws CVSException {
            return this.m_folder.getSyncInfo().getBytes();
        }

        IPath getPath() {
            return this.m_path;
        }

        boolean isEmpty() {
            return this.m_entries.isEmpty();
        }

        boolean isPrefixOf(IPath path) {
            return this.m_path.isPrefixOf(path);
        }

        void writeSync() throws CVSException {
            this.assertCreated();
            IPath cvsFolder = FileSystemCopier.createDirectory(this.m_path.append(FileSystemCopier.CVS_DIRNAME));
            int idx = this.m_entries.size();
            String[] entries = new String[idx];
            while (--idx >= 0) {
                entries[idx] = new String(this.m_entries.get(idx));
            }
            FileSystemCopier.writeLines(cvsFolder, FileSystemCopier.ENTRIES, entries);
            FolderSyncInfo info = this.m_folder.getFolderSyncInfo();
            FileSystemCopier.writeLines(cvsFolder, FileSystemCopier.ROOT, new String[]{info.getRoot()});
            FileSystemCopier.writeLines(cvsFolder, FileSystemCopier.REPOSITORY, new String[]{info.getRepository()});
            if (info.getTag() != null) {
                FileSystemCopier.writeLines(cvsFolder, FileSystemCopier.TAG, new String[]{info.getTag().toEntryLineFormat(false)});
            }
            if (info.getIsStatic()) {
                FileSystemCopier.writeLines(cvsFolder, FileSystemCopier.STATIC, new String[]{""});
            }
        }
    }
}

