/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.galileo.builder;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.amalgam.releng.build.Build;
import org.eclipse.amalgam.releng.build.Bundle;
import org.eclipse.amalgam.releng.build.Contribution;
import org.eclipse.amalgam.releng.build.Feature;
import org.eclipse.buckminster.galileo.builder.Builder;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllContributedCapabilitiesAction
extends AbstractPublisherAction {
    private final Builder builder;
    private final IMetadataRepository mdr;
    private final IMetadataRepository globalMdr;

    private static Map<String, String> getIUProperties(IInstallableUnit iu) {
        return iu.getProperties();
    }

    public AllContributedCapabilitiesAction(Builder builder, IMetadataRepository globalMdr, IMetadataRepository mdr) {
        this.builder = builder;
        this.globalMdr = globalMdr;
        this.mdr = mdr;
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        Logger log = Buckminster.getLogger();
        Feature brandingFeature = this.builder.getBrandingFeature();
        if (brandingFeature == null || !this.builder.isBrandingBuild()) {
            return Status.OK_STATUS;
        }
        Build build = this.builder.getBuild();
        IInstallableUnit existingCapIU = Builder.getIU(this.globalMdr, String.valueOf(brandingFeature.getId()) + ".feature.group", brandingFeature.getVersion());
        if (existingCapIU != null) {
            log.info("Found existing capabilities feature: %s/%s, extending...", new Object[]{existingCapIU.getId(), existingCapIU.getVersion()});
        } else {
            log.info("Creating new capabilities feature: %s/%s...", new Object[]{brandingFeature.getId(), brandingFeature.getVersion()});
        }
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        iu.setId(String.valueOf(brandingFeature.getId()) + ".feature.group");
        ArrayList<IRequiredCapability> required = new ArrayList<IRequiredCapability>();
        boolean didExtend = false;
        EList contribs = build.getContributions();
        for (Contribution contrib : contribs) {
            for (Feature feature : contrib.getFeatures()) {
                if (feature == brandingFeature || !Builder.isCapabilitiesFeature(feature)) continue;
                String featureId = String.valueOf(feature.getId()) + ".feature.group";
                IInstallableUnit featureIU = Builder.getIU(this.globalMdr, featureId, feature.getVersion());
                IRequiredCapability[] iRequiredCapabilityArray = featureIU.getRequiredCapabilities();
                int n = iRequiredCapabilityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IRequiredCapability cap = iRequiredCapabilityArray[n2];
                    if ("org.eclipse.equinox.p2.iu".equals(cap.getNamespace()) && !cap.getName().endsWith(".feature.jar")) {
                        didExtend = true;
                        log.info("Adding capabilities bundle: %s/%s", new Object[]{cap.getName(), cap.getRange()});
                        required.add(cap);
                    }
                    ++n2;
                }
            }
            for (Bundle bundle : contrib.getBundles()) {
                if (!Builder.isCapabilitiesBundle(bundle)) continue;
                IInstallableUnit bundleIU = Builder.getIU(this.globalMdr, bundle.getId(), bundle.getVersion());
                Version v = bundleIU.getVersion();
                VersionRange vr = new VersionRange(v, true, v, true);
                IRequiredCapability cap = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)bundleIU.getId(), (VersionRange)vr, (String)bundleIU.getFilter(), (boolean)true, (boolean)false);
                didExtend = true;
                log.info("Adding capabilities bundle: %s/%s", new Object[]{cap.getName(), cap.getRange()});
                required.add(cap);
            }
        }
        if (!didExtend) {
            if (existingCapIU == null) {
                block6: for (Contribution contrib : contribs) {
                    EList features = contrib.getFeatures();
                    for (Feature feature : features) {
                        if (feature != brandingFeature) continue;
                        features.remove(feature);
                        this.builder.setBrandingContribution(null);
                        break block6;
                    }
                }
            }
            log.info("Done. Found no contributed capabilities", new Object[0]);
            return Status.OK_STATUS;
        }
        Version version = Version.parseVersion((String)brandingFeature.getVersion());
        String timestamp = String.valueOf(build.getDate()) + '-' + build.getTime();
        if (existingCapIU == null) {
            iu.setProperty("org.eclipse.equinox.p2.name", String.valueOf(build.getLabel()) + " Capability Definitions");
            if ("qualifier".equals(version.getQualifier())) {
                version = Version.createOSGi((int)version.getMajor(), (int)version.getMinor(), (int)version.getMicro(), (String)timestamp);
            }
        } else {
            IRequiredCapability[] iRequiredCapabilityArray = existingCapIU.getRequiredCapabilities();
            int n = iRequiredCapabilityArray.length;
            int feature = 0;
            while (feature < n) {
                IRequiredCapability cap = iRequiredCapabilityArray[feature];
                required.add(cap);
                ++feature;
            }
            for (Map.Entry<String, String> entry : AllContributedCapabilitiesAction.getIUProperties(existingCapIU).entrySet()) {
                iu.setProperty(entry.getKey(), entry.getValue());
            }
            iu.setLicense(existingCapIU.getLicense());
            iu.setCopyright(existingCapIU.getCopyright());
            String qualifier = version.getQualifier();
            if (qualifier == null || "qualifier".equals(qualifier)) {
                qualifier = timestamp;
            } else {
                try {
                    if (qualifier.startsWith("v2")) {
                        Builder.TIMESTAMP_FORMAT.parse(qualifier.substring(1));
                        qualifier = String.valueOf('v') + timestamp;
                    } else {
                        Builder.TIMESTAMP_FORMAT.parse(qualifier);
                        qualifier = timestamp;
                    }
                }
                catch (ParseException e) {
                    qualifier = String.valueOf(qualifier) + '-' + timestamp;
                }
            }
            version = Version.createOSGi((int)version.getMajor(), (int)version.getMinor(), (int)version.getMicro(), (String)qualifier);
        }
        brandingFeature.setVersion(version.toString());
        iu.setVersion(version);
        iu.addProvidedCapabilities(Collections.singletonList(this.createSelfCapability(iu.getId(), iu.getVersion())));
        iu.addRequiredCapabilities(required);
        this.mdr.addInstallableUnits(new IInstallableUnit[]{MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu)});
        if (existingCapIU == null) {
            log.info("Done creating capabilites feature. Version is %s", new Object[]{version});
        } else {
            log.info("Done extending capabilities feature. Version is %s", new Object[]{version});
        }
        return Status.OK_STATUS;
    }
}

