/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.galileo.builder;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.amalgam.releng.build.Bundle;
import org.eclipse.amalgam.releng.build.Contribution;
import org.eclipse.amalgam.releng.build.Feature;
import org.eclipse.amalgam.releng.build.Product;
import org.eclipse.buckminster.galileo.builder.Builder;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;

public class AllContributedContentAction
extends AbstractPublisherAction {
    private final Builder builder;
    private final IMetadataRepository mdr;
    private final IMetadataRepository globalMdr;

    public AllContributedContentAction(Builder builder, IMetadataRepository globalMdr, IMetadataRepository mdr) {
        this.builder = builder;
        this.globalMdr = globalMdr;
        this.mdr = mdr;
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        IInstallableUnit gcapIU;
        Logger log = Buckminster.getLogger();
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("all.contributed.content.feature.group");
        iu.setVersion(Builder.ALL_CONTRIBUTED_CONTENT_VERSION);
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        iu.addProvidedCapabilities(Collections.singletonList(this.createSelfCapability(iu.getId(), iu.getVersion())));
        Feature brandingFeature = this.builder.getBrandingFeature();
        boolean skipBrandingFeature = false;
        ArrayList<IRequiredCapability> required = new ArrayList<IRequiredCapability>();
        if (brandingFeature != null && this.builder.isBrandingBuild() && (gcapIU = Builder.getIU(this.mdr, String.valueOf(brandingFeature.getId()) + ".feature.group", brandingFeature.getVersion())) != null) {
            Version v = gcapIU.getVersion();
            VersionRange range = null;
            if (!Version.emptyVersion.equals((Object)v)) {
                range = new VersionRange(v, true, v, true);
            }
            required.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)gcapIU.getId(), (VersionRange)range, null, (boolean)false, (boolean)false));
            skipBrandingFeature = true;
        }
        boolean errorsFound = false;
        for (Contribution contrib : this.builder.getBuild().getContributions()) {
            String filter;
            VersionRange range;
            Version v;
            ArrayList<String> errors = new ArrayList<String>();
            for (Feature feature : contrib.getFeatures()) {
                String requiredId = feature.getId();
                if (this.builder.skipFeature(feature, errors) || brandingFeature != null && brandingFeature.getId().equals(feature.getId()) && (skipBrandingFeature || feature.getRepo() == null)) continue;
                IInstallableUnit featureIU = Builder.getIU(this.globalMdr, requiredId = String.valueOf(requiredId) + ".feature.group", feature.getVersion());
                if (this.builder.discardAsUnverified(featureIU)) {
                    log.debug("Feature %s/%s excluded from verification", new Object[]{requiredId, feature.getVersion()});
                    continue;
                }
                Version v2 = featureIU.getVersion();
                VersionRange range2 = null;
                if (!Version.emptyVersion.equals((Object)v2)) {
                    range2 = new VersionRange(v2, true, v2, true);
                }
                String filter2 = featureIU.getFilter();
                required.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)requiredId, (VersionRange)range2, (String)filter2, (boolean)false, (boolean)false));
            }
            for (Bundle bundle : contrib.getBundles()) {
                IInstallableUnit bundleIU = Builder.getIU(this.globalMdr, bundle.getId(), bundle.getVersion());
                if (this.builder.discardAsUnverified(bundleIU)) continue;
                v = bundleIU.getVersion();
                range = new VersionRange(v, true, v, true);
                filter = bundleIU.getFilter();
                required.add(MetadataFactory.createRequiredCapability((String)"osgi.bundle", (String)bundleIU.getId(), (VersionRange)range, (String)filter, (boolean)false, (boolean)false));
            }
            for (Product product : contrib.getProducts()) {
                IInstallableUnit productIU = Builder.getIU(this.globalMdr, product.getId(), product.getVersion());
                v = productIU.getVersion();
                range = new VersionRange(v, true, v, true);
                filter = productIU.getFilter();
                required.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)productIU.getId(), (VersionRange)range, (String)filter, (boolean)false, (boolean)false));
            }
            if (errors.size() <= 0) continue;
            errorsFound = true;
            this.builder.sendEmail(contrib, errors);
        }
        if (errorsFound) {
            return new Status(4, "org.eclipse.buckminster.galileo.builder", "Features without repositories");
        }
        iu.addRequiredCapabilities(required);
        this.mdr.addInstallableUnits(new IInstallableUnit[]{MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu)});
        return Status.OK_STATUS;
    }
}

