/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.galileo.builder;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.amalgam.releng.build.BuildFactory;
import org.eclipse.amalgam.releng.build.Feature;
import org.eclipse.amalgam.releng.build.Repository;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.actor.IGlobalContext;
import org.eclipse.buckminster.core.actor.IPerformManager;
import org.eclipse.buckminster.core.commands.Build;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.materializer.MaterializationJob;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.mspec.builder.MaterializationSpecBuilder;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.MainResolver;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.rmap.model.Locator;
import org.eclipse.buckminster.core.rmap.model.Matcher;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.galileo.builder.Builder;
import org.eclipse.buckminster.galileo.builder.BuilderPhase;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.mapprovider.PDEMapProvider;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.xml.sax.SAXException;

public class BrandingFeatureCompiler
extends BuilderPhase {
    private final Feature brandingFeature;
    private final ComponentIdentifier brandingCI;

    protected BrandingFeatureCompiler(Builder builder, Feature brandingFeature) {
        super(builder);
        this.brandingFeature = brandingFeature;
        this.brandingCI = new ComponentIdentifier(brandingFeature.getId(), "eclipse.feature", Version.parseVersion((String)brandingFeature.getVersion()));
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (this.brandingFeature == null) {
            return;
        }
        MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
        this.populateWorkspace(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)80));
        this.buildSite(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
    }

    private void buildSite(IProgressMonitor monitor) throws CoreException {
        Logger log = Buckminster.getLogger();
        log.info("Building update site containing %s", new Object[]{this.brandingFeature});
        long now = System.currentTimeMillis();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
        try {
            ArrayList<String> errors = null;
            IMarker[] iMarkerArray = Build.build((IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)18), (boolean)true);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker problem = iMarkerArray[n2];
                switch (problem.getAttribute("severity", 0)) {
                    case 2: {
                        String error = Build.formatMarkerMessage((String)"Error", (IMarker)problem);
                        log.error(error, new Object[0]);
                        if (errors == null) {
                            errors = new ArrayList<String>();
                        }
                        errors.add(error);
                        break;
                    }
                    case 1: {
                        log.warning(Build.formatMarkerMessage((String)"Warning", (IMarker)problem), new Object[0]);
                        break;
                    }
                    case 0: {
                        log.info(Build.formatMarkerMessage((String)"Info", (IMarker)problem), new Object[0]);
                    }
                }
                ++n2;
            }
            if (errors != null) {
                this.getBuilder().sendEmail(null, errors);
                throw BuckminsterException.fromMessage((String)"Build failed", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        CSpec cspec = WorkspaceInfo.getResolution((ComponentIdentifier)this.brandingCI).getCSpec();
        Attribute attr = cspec.getRequiredAttribute("site.p2");
        IPerformManager pm = CorePlugin.getPerformManager();
        HashMap<String, String> props = new HashMap<String, String>();
        File actionOutputRoot = new File(this.getBuilder().getBuildRoot(), "branding");
        props.put("buckminster.output.root", actionOutputRoot.toString());
        props.put("buckminster.temp.root", new File(actionOutputRoot, "build.tmp").toString());
        props.put("qualifier.replacement.*", "generator:lastModified");
        props.put("generator.lastModified.format", "'v'yyyyMMdd-HHmm");
        props.put("site.pack200", "true");
        props.put("site.include.top", "true");
        IGlobalContext ctx = pm.perform((ICSpecData)cspec, attr.getName(), props, false, true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)70));
        Map siteBuildProps = ctx.getExecutionProperties(attr);
        IPath buildOutput = Path.fromOSString((String)((String)ExpandingProperties.expand((Map)siteBuildProps, (Object)IPDEConstants.OUTPUT_DIR_SITE_P2.toOSString(), (int)0)));
        URI brandingRepo = buildOutput.toFile().toURI();
        Buckminster bucky = Buckminster.getDefault();
        IArtifactRepositoryManager arMgr = (IArtifactRepositoryManager)bucky.getService(IArtifactRepositoryManager.class);
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)bucky.getService(IMetadataRepositoryManager.class);
        try {
            IMetadataRepository mdr = mdrMgr.loadRepository(brandingRepo, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)2));
            IInstallableUnit bfIU = Builder.getIU(mdr, String.valueOf(cspec.getName()) + ".feature.group", null);
            if (bfIU == null) {
                throw BuckminsterException.fromMessage((String)"No %s feature was generated during workspace build", (Object[])new Object[]{this.brandingCI.getName()});
            }
            this.brandingFeature.setVersion(bfIU.getVersion().toString());
            Repository repo = BuildFactory.eINSTANCE.createRepository();
            repo.setLocation(brandingRepo.toString());
            repo.setLabel(String.valueOf(this.getBuilder().getBuild().getLabel()) + " branding feature repository");
            this.brandingFeature.setRepo(repo);
            URI globalLocationURI = this.getBuilder().getGlobalRepoURI();
            ((CompositeMetadataRepository)mdrMgr.loadRepository(globalLocationURI, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5))).addChild(brandingRepo);
            ((CompositeArtifactRepository)arMgr.loadRepository(globalLocationURI, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5))).addChild(brandingRepo);
        }
        finally {
            bucky.ungetService((Object)mdrMgr);
        }
        log.info("Done building update site. Took %d ms", new Object[]{System.currentTimeMillis() - now});
    }

    private ComponentQuery createQuery() throws CoreException {
        ComponentQueryBuilder bld = new ComponentQueryBuilder();
        Version v = this.brandingCI.getVersion();
        VersionRange vr = Version.emptyVersion.equals((Object)v) ? null : new VersionRange(v, true, v, true);
        bld.setRootRequest((IComponentRequest)new ComponentRequest(this.brandingCI.getName(), this.brandingCI.getComponentTypeID(), vr));
        bld.setPlatformAgnostic(true);
        bld.setResourceMapURL(this.createResourceMap().toURI().toString());
        return bld.createComponentQuery();
    }

    private File createResourceMap() throws CoreException {
        try {
            File rmapFile = new File(this.getBuilder().getBuildRoot(), "buckminster.rmap");
            if (rmapFile.exists()) {
                return rmapFile;
            }
            File mapFolder = new File(this.getBuilder().getBuildModelLocation().getParent(), "maps");
            ResourceMap rmap = new ResourceMap(null);
            SearchPath searchPath = new SearchPath(rmap, "builder.map");
            searchPath.addProvider((Provider)new PDEMapProvider(searchPath, "url.catalog", new String[]{"eclipse.feature", "osgi.bundle"}, null, new Format(mapFolder.toURI().toString()), null, false, true, null));
            rmap.addSearchPath(searchPath);
            searchPath = new SearchPath(rmap, "contributions");
            searchPath.addProvider(new Provider(searchPath, "eclipse.import", new String[]{"eclipse.feature", "osgi.bundle"}, null, new Format(this.getBuilder().getGlobalRepoURI().toString()), null, null, null, false, false, null, null));
            rmap.addSearchPath(searchPath);
            rmap.addMatcher((Matcher)new Locator(rmap, null, "builder.map", false));
            rmap.addMatcher((Matcher)new Locator(rmap, null, "contributions", false));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(rmapFile));
            try {
                Utils.serialize((ISaxable)rmap, (OutputStream)out);
            }
            finally {
                IOUtils.close((Closeable)out);
            }
            return rmapFile;
        }
        catch (SAXException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    private void populateWorkspace(IProgressMonitor monitor) throws CoreException {
        Logger log = Buckminster.getLogger();
        log.info("Populating workspace", new Object[0]);
        MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
        long now = System.currentTimeMillis();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wsDesc = ws.getDescription();
        wsDesc.setAutoBuilding(false);
        wsDesc.setSnapshotInterval(Long.MAX_VALUE);
        ws.setDescription(wsDesc);
        ws.save(true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5));
        ComponentQuery query = this.createQuery();
        ResolutionContext ctx = new ResolutionContext(query);
        MainResolver resolver = new MainResolver(ctx);
        BillOfMaterials bom = resolver.resolve(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)95));
        MaterializationSpecBuilder mspecBld = new MaterializationSpecBuilder();
        mspecBld.setName(bom.getViewName());
        mspecBld.setMaterializerID("workspace");
        bom.addMaterializationNodes(mspecBld);
        MaterializationContext matCtx = new MaterializationContext(bom, mspecBld.createMaterializationSpec());
        MaterializationJob.run((MaterializationContext)matCtx);
        MonitorUtils.done((IProgressMonitor)monitor);
        log.info("Done. Took %d ms", new Object[]{System.currentTimeMillis() - now});
    }
}

