/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.galileo.builder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.mail.MailMessage;
import org.eclipse.amalgam.releng.build.Build;
import org.eclipse.amalgam.releng.build.BuildPackage;
import org.eclipse.amalgam.releng.build.Contact;
import org.eclipse.amalgam.releng.build.Contribution;
import org.eclipse.amalgam.releng.build.Feature;
import org.eclipse.amalgam.releng.build.Promotion;
import org.eclipse.amalgam.releng.build.Repository;
import org.eclipse.buckminster.galileo.builder.BrandingFeatureCompiler;
import org.eclipse.buckminster.galileo.builder.CategoryRepoGenerator;
import org.eclipse.buckminster.galileo.builder.CompositeRepoGenerator;
import org.eclipse.buckminster.galileo.builder.MirrorGenerator;
import org.eclipse.buckminster.galileo.builder.RepositoryVerifier;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.gmf.internal.xpand.ant.XpandFacade;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder
implements IApplication {
    public static final String ALL_CONTRIBUTED_CONTENT_FEATURE = "all.contributed.content.feature.group";
    public static final String PDE_TARGET_PLATFORM_NAMESPACE = "A.PDE.Target.Platform";
    public static final Version ALL_CONTRIBUTED_CONTENT_VERSION = Version.createOSGi((int)1, (int)0, (int)0);
    public static final String COMPOSITE_ARTIFACTS_TYPE = "org.eclipse.equinox.p2.artifact.repository.compositeRepository";
    public static final String COMPOSITE_METADATA_TYPE = "org.eclipse.equinox.p2.metadata.repository.compositeRepository";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String NAMESPACE_OSGI_BUNDLE = "osgi.bundle";
    public static final String PROFILE_ID = "GalileoTest";
    public static final String REPO_FOLDER_CATEGORIES = "categories";
    public static final String REPO_FOLDER_FINAL = "final";
    public static final String REPO_FOLDER_INTERIM = "interim";
    public static final String REPO_FOLDER_AGGREGATE = "aggregate";
    public static final String SIMPLE_ARTIFACTS_TYPE = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";
    public static final String SIMPLE_METADATA_TYPE = "org.eclipse.equinox.p2.metadata.repository.simpleRepository";
    public static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmm");
    static final String FEATURE_GROUP_SUFFIX = ".feature.group";
    private static final String BUNDLE_ECF_FS_PROVIDER = "org.eclipse.ecf.provider.filetransfer";
    private static final String BUNDLE_EXEMPLARY_SETUP = "org.eclipse.equinox.p2.exemplarysetup";
    private static final String BUNDLE_UPDATESITE = "org.eclipse.equinox.p2.updatesite";
    private static final String CORE_BUNDLE = "org.eclipse.equinox.p2.core";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final String PROP_P2_DATA_AREA = "eclipse.p2.data.area";
    private static final String PROP_P2_PROFILE = "eclipse.p2.profile";
    private static final Project PROPERTY_REPLACER = new Project();
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HHmm");
    private final List<String> trustedContributions = new ArrayList<String>();
    private Build build;
    private String buildID;
    private String buildLabel;
    private String buildMasterEmail;
    private String buildMasterName;
    private File buildModelLocation;
    private File buildRoot;
    private String brandingContribution;
    private Feature brandingFeature;
    private java.net.URI categoriesRepo;
    private String emailFrom;
    private String emailFromName;
    private int logLevel = 1;
    private String logURL;
    private String mockEmailCC;
    private String mockEmailTo;
    private boolean brandingBuild = true;
    private boolean mirrorReferences = false;
    private Pattern referenceIncludePattern;
    private Pattern referenceExcludePattern;
    private boolean production = false;
    private PackedStrategy packedStrategy = PackedStrategy.COPY;
    private ResourceSet resourceSet;
    private boolean sendmail = false;
    private String smtpHost;
    private int smtpPort;
    private String subjectPrefix;
    private Set<IInstallableUnit> unitsToAggregate;
    private Set<IInstallableUnit> trustedUnits;
    private Set<IInstallableUnit> unverifiedUnits;
    private boolean update = false;
    private boolean verifyOnly = false;
    private java.net.URI[] trustedContributionRepos;

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        PROPERTY_REPLACER.initProperties();
        DATE_FORMAT.setTimeZone(utc);
        TIME_FORMAT.setTimeZone(utc);
        TIMESTAMP_FORMAT.setTimeZone(utc);
    }

    private static void deleteAllButWorkspace(File folder, IPath wsPath) throws CoreException {
        File[] children = folder.listFiles();
        if (children == null) {
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            IPath childPath = Path.fromOSString((String)child.getAbsolutePath());
            if (childPath.isPrefixOf(wsPath)) {
                if (!childPath.equals((Object)wsPath)) {
                    Builder.deleteAllButWorkspace(child, wsPath);
                }
            } else {
                FileUtils.deleteAll((File)child);
                if (child.exists()) {
                    throw BuckminsterException.fromMessage((String)"Failed to delete folder %s", (Object[])new Object[]{childPath});
                }
            }
            ++n2;
        }
    }

    private static synchronized Bundle getBundle(PackageAdmin packageAdmin, String symbolicName) {
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            if ((bundle.getState() & 3) == 0) {
                return bundle;
            }
            ++i;
        }
        return null;
    }

    private static void getExceptionMessages(Throwable e, StringBuilder bld) {
        bld.append(e.getClass().getName());
        bld.append(": ");
        if (e.getMessage() != null) {
            bld.append(e.getMessage());
        }
        if (e instanceof CoreException) {
            e = ((CoreException)e).getStatus().getException();
        } else {
            Throwable t = e.getCause();
            Throwable throwable = e = t == e ? null : t;
        }
        if (e != null) {
            bld.append("\nCaused by: ");
            Builder.getExceptionMessages(e, bld);
        }
    }

    public static IInstallableUnit getIU(IMetadataRepository mdr, String id, String version) {
        InstallableUnitQuery query = (version = Trivial.trim((String)version)) == null ? new InstallableUnitQuery(id) : new InstallableUnitQuery(id, Version.create((String)version));
        Collector c = mdr.query((Query)query, new Collector(), null);
        IInstallableUnit[] result = (IInstallableUnit[])c.toArray(IInstallableUnit.class);
        return result.length > 0 ? result[0] : null;
    }

    public static boolean isCapabilitiesBundle(org.eclipse.amalgam.releng.build.Bundle bundle) {
        String id = bundle.getId();
        return id.endsWith(".capabilities") && bundle.getRepo() != null;
    }

    public static boolean isCapabilitiesFeature(Feature feature) {
        String id = feature.getId();
        return (id.endsWith(".capabilities") || id.endsWith(".capabilities.feature")) && feature.getRepo() != null && feature.getCategory().size() == 0;
    }

    private static void requiresArgument(String opt) {
        throw new IllegalArgumentException("Option " + opt + " requires an argument");
    }

    private static void send(String host, int port, EmailAddress from, List<EmailAddress> toList, EmailAddress cc, String subject, String message) throws IOException {
        MailMessage mailMessage = new MailMessage(host, port);
        mailMessage.from(from.toString());
        for (EmailAddress to : toList) {
            mailMessage.to(to.toString());
        }
        if (cc != null) {
            mailMessage.cc(cc.toString());
        }
        mailMessage.setSubject(subject);
        mailMessage.setHeader("Date", DateUtils.getDateForHeader());
        mailMessage.setHeader("Content-Type", "text/plain; charset=us-ascii");
        PrintStream out = mailMessage.getPrintStream();
        out.print(message);
        mailMessage.sendAndClose();
    }

    private static boolean startEarly(PackageAdmin packageAdmin, String bundleName) throws BundleException {
        Bundle bundle = Builder.getBundle(packageAdmin, bundleName);
        if (bundle == null) {
            return false;
        }
        bundle.start(1);
        return true;
    }

    private static boolean stopBundle(PackageAdmin packageAdmin, String bundleName) throws BundleException {
        Bundle bundle = Builder.getBundle(packageAdmin, bundleName);
        if (bundle == null || bundle.getState() != 32) {
            return false;
        }
        bundle.stop(1);
        return true;
    }

    public static final java.net.URI createURI(File repoLocation) throws CoreException {
        IPath path;
        if (repoLocation != null && (path = Path.fromOSString((String)repoLocation.getPath())).isAbsolute()) {
            try {
                String pathStr = path.removeTrailingSeparator().toPortableString();
                if (!pathStr.startsWith("/")) {
                    pathStr = "/" + pathStr;
                }
                return new java.net.URI("file", null, pathStr, null);
            }
            catch (URISyntaxException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        throw BuckminsterException.fromMessage((String)"File %s is not an absolute path", (Object[])new Object[]{repoLocation});
    }

    public static String getExceptionMessages(Throwable e) {
        StringBuilder bld = new StringBuilder();
        Builder.getExceptionMessages(e, bld);
        return bld.toString();
    }

    public boolean discardAsUnverified(IInstallableUnit iu) {
        IRequiredCapability[] iRequiredCapabilityArray = iu.getRequiredCapabilities();
        int n = iRequiredCapabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRequiredCapability rq = iRequiredCapabilityArray[n2];
            if (PDE_TARGET_PLATFORM_NAMESPACE.equals(rq.getNamespace())) {
                if (this.unverifiedUnits == null) {
                    this.unverifiedUnits = new HashSet<IInstallableUnit>();
                }
                this.unverifiedUnits.add(iu);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Feature getBrandingFeature() {
        return this.brandingFeature;
    }

    public Build getBuild() {
        return this.build;
    }

    public String getBuildID() {
        return this.buildID;
    }

    public File getBuildModelLocation() {
        return this.buildModelLocation;
    }

    public File getBuildRoot() {
        return this.buildRoot;
    }

    public java.net.URI getCategoriesRepo() {
        return this.categoriesRepo;
    }

    public java.net.URI getGlobalRepoURI() throws CoreException {
        return Builder.createURI(new File(this.buildRoot, REPO_FOLDER_INTERIM));
    }

    public java.net.URI getMirrorsURI(boolean aggregate) throws CoreException {
        Promotion promotion = this.build.getPromotion();
        if (promotion == null) {
            return null;
        }
        String baseURL = promotion.getBaseURL();
        if (baseURL == null) {
            return null;
        }
        java.net.URI mirrorsURI = java.net.URI.create(PROPERTY_REPLACER.replaceProperties(baseURL));
        String downloadDirectory = PROPERTY_REPLACER.replaceProperties(promotion.getDownloadDirectory());
        if (downloadDirectory != null) {
            try {
                if (mirrorsURI.getPath().endsWith("/download.php")) {
                    Map<String, String> params;
                    String query = mirrorsURI.getQuery();
                    Map map = params = query == null ? new HashMap() : URLUtils.queryAsParameters((String)query);
                    if (aggregate) {
                        downloadDirectory = downloadDirectory.endsWith("/") ? String.valueOf(downloadDirectory) + "aggregate/" : String.valueOf(downloadDirectory) + "/aggregate";
                    }
                    params.put("file", downloadDirectory);
                    if (!params.containsKey("protocol")) {
                        params.put("protocol", "http");
                    }
                    if (!params.containsKey("format")) {
                        params.put("format", "xml");
                    }
                    mirrorsURI = new java.net.URI(mirrorsURI.getScheme(), mirrorsURI.getAuthority(), mirrorsURI.getPath(), URLUtils.encodeFromQueryPairs(params), mirrorsURI.getFragment());
                } else {
                    mirrorsURI = new java.net.URI(mirrorsURI.getScheme(), mirrorsURI.getHost(), String.valueOf(mirrorsURI.getPath()) + '/' + downloadDirectory, mirrorsURI.getFragment());
                }
            }
            catch (URISyntaxException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        return mirrorsURI;
    }

    public PackedStrategy getPackedStrategy() {
        return this.packedStrategy;
    }

    public java.net.URI[] getTrustedContributionRepos() {
        return this.trustedContributionRepos;
    }

    public Set<IInstallableUnit> getTrustedUnits() {
        return this.trustedUnits;
    }

    public Set<IInstallableUnit> getUnitsToAggregate() {
        return this.unitsToAggregate;
    }

    public Set<IInstallableUnit> getUnverifiedUnits() {
        return this.unverifiedUnits == null ? Collections.emptySet() : this.unverifiedUnits;
    }

    public boolean isBrandingBuild() {
        return this.brandingBuild;
    }

    public boolean isMatchedReference(String reference) {
        Matcher m;
        if ((reference = Trivial.trim((String)reference)) == null) {
            return false;
        }
        if (this.referenceIncludePattern != null && !(m = this.referenceIncludePattern.matcher(reference)).matches()) {
            return false;
        }
        return this.referenceExcludePattern == null || !(m = this.referenceExcludePattern.matcher(reference)).matches();
    }

    public boolean isMirrorReferences() {
        return this.mirrorReferences;
    }

    public boolean isProduction() {
        return this.production;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public boolean isVerifyOnly() {
        return this.verifyOnly;
    }

    private EmailAddress mockCCRecipient() throws UnsupportedEncodingException {
        EmailAddress mock = null;
        if (this.mockEmailCC != null) {
            mock = new EmailAddress(this.mockEmailCC, null);
        }
        return mock;
    }

    private List<EmailAddress> mockRecipients() throws UnsupportedEncodingException {
        if (this.mockEmailTo != null) {
            return Collections.singletonList(new EmailAddress(this.mockEmailTo, null));
        }
        return Collections.emptyList();
    }

    private void parseCommandLineArgs(String[] args) {
        int top = args.length;
        int idx = 0;
        while (idx < top) {
            String arg = args[idx];
            if ("-verifyOnly".equalsIgnoreCase(arg)) {
                this.setVerifyOnly(true);
            } else if ("-updateOnly".equalsIgnoreCase(arg)) {
                this.setUpdate(true);
            } else if ("-production".equalsIgnoreCase(arg)) {
                this.setProduction(true);
            } else if ("-packedStrategy".equalsIgnoreCase(arg)) {
                PackedStrategy strategy;
                String strategyStr;
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                if ("copy".equalsIgnoreCase(strategyStr = args[idx])) {
                    strategy = PackedStrategy.COPY;
                } else if ("verify".equalsIgnoreCase(strategyStr)) {
                    strategy = PackedStrategy.VERIFY;
                } else if ("unpackAsSibling".equalsIgnoreCase(strategyStr)) {
                    strategy = PackedStrategy.UNPACK_AS_SIBLING;
                } else if ("unpack".equalsIgnoreCase(strategyStr)) {
                    strategy = PackedStrategy.UNPACK;
                } else if ("skip".equalsIgnoreCase(strategyStr)) {
                    strategy = PackedStrategy.SKIP;
                } else {
                    throw new IllegalArgumentException(String.format("%s is not a valid packed strategy", strategyStr));
                }
                this.setPackedStrategy(strategy);
            } else if ("-logLevel".equalsIgnoreCase(arg)) {
                int level;
                String levelStr;
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                if ("debug".equalsIgnoreCase(levelStr = args[idx])) {
                    level = 0;
                } else if ("info".equalsIgnoreCase(levelStr)) {
                    level = 1;
                } else if ("warning".equalsIgnoreCase(levelStr)) {
                    level = 2;
                } else if ("error".equalsIgnoreCase(levelStr)) {
                    level = 2;
                } else {
                    throw new IllegalArgumentException(String.format("%s is not a valid logLevel", levelStr));
                }
                this.setLogLevel(level);
            } else if ("-logURL".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setLogURL(args[idx]);
            } else if ("-mockEmailTo".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setMockEmailTo(args[idx]);
            } else if ("-subjectPrefix".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setSubjectPrefix(args[idx]);
            } else if ("-emailFrom".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setEmailFrom(args[idx]);
            } else if ("-emailFromName".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setEmailFromName(args[idx]);
            } else if ("-smtpHost".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setSmtpHost(args[idx]);
            } else if ("-smtpPort".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                int portNumber = 0;
                try {
                    portNumber = Integer.parseInt(args[idx]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (portNumber <= 0) {
                    Builder.requiresArgument(arg);
                }
                this.setSmtpPort(portNumber);
            } else if ("-mockEmailCC".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setMockEmailCC(args[idx]);
            } else if ("-buildModel".equalsIgnoreCase(arg)) {
                File buildModel;
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                if (!(buildModel = new File(args[idx])).canRead()) {
                    throw new IllegalArgumentException(String.format("Unable to read %s", buildModel));
                }
                this.setBuildModelLocation(buildModel);
            } else if ("-buildRoot".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setBuildRoot(new File(args[idx]));
            } else if ("-buildId".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setBuildID(args[idx]);
            } else if ("-brandingContribution".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setBrandingContribution(args[idx]);
            } else if ("-mirrorReferences".equalsIgnoreCase(arg)) {
                this.setMirrorReferences(true);
            } else if ("-referenceIncludePattern".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setReferenceIncludePattern(args[idx]);
            } else if ("-referenceExcludePattern".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setReferenceExcludePattern(args[idx]);
            } else if ("-noBrandingBuild".equalsIgnoreCase(arg)) {
                this.setBrandingBuild(false);
            } else if ("-trustedContributions".equalsIgnoreCase(arg)) {
                if (++idx >= top) {
                    Builder.requiresArgument(arg);
                }
                this.setTrustedContributions(args[idx]);
            } else {
                String msg = String.format("Unknown option %s", arg);
                Buckminster.getLogger().error(msg, new Object[0]);
                throw new IllegalArgumentException(msg);
            }
            ++idx;
        }
    }

    public Object run(IProgressMonitor monitor) {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(this.verifyOnly ? 200 : 1100));
        try {
            try {
                if (this.buildModelLocation == null) {
                    throw BuckminsterException.fromMessage((String)"No buildmodel has been set", (Object[])new Object[0]);
                }
                Date now = new Date();
                if (this.buildID == null) {
                    this.buildID = "build-" + DATE_FORMAT.format(now) + TIME_FORMAT.format(now);
                }
                if (this.smtpHost == null) {
                    this.smtpHost = "localhost";
                }
                if (this.smtpPort <= 0) {
                    this.smtpPort = 25;
                }
                if (!this.update) {
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    FileUtils.deleteAll((File)new File(wsRoot.getLocation().toOSString(), ".metadata/.plugins/org.eclipse.buckminster.core"));
                    wsRoot.delete(5, (IProgressMonitor)new NullProgressMonitor());
                }
                this.verifyContributions();
                this.runTransformation(now);
                EList contributions = this.build.getContributions();
                if (this.brandingContribution != null) {
                    this.brandingFeature = null;
                    for (Contribution contrib : contributions) {
                        if (!this.brandingContribution.equals(contrib.getLabel())) continue;
                        EList features = contrib.getFeatures();
                        if (features.size() == 1) {
                            this.brandingFeature = (Feature)features.get(0);
                            break;
                        }
                        throw BuckminsterException.fromMessage((String)"The capability contribution %s does not have exactly one feature", (Object[])new Object[]{this.brandingContribution});
                    }
                    if (this.brandingFeature == null) {
                        throw BuckminsterException.fromMessage((String)"Unable to find capability contribution %s in the build model", (Object[])new Object[]{this.brandingContribution});
                    }
                }
                if (this.trustedContributions.size() > 0) {
                    ArrayList<java.net.URI> allRepos = new ArrayList<java.net.URI>(this.trustedContributions.size());
                    for (String trusted : this.trustedContributions) {
                        Contribution tc = null;
                        for (Contribution contrib : contributions) {
                            if (!trusted.equals(contrib.getLabel())) continue;
                            tc = contrib;
                            break;
                        }
                        if (tc == null) {
                            throw BuckminsterException.fromMessage((String)"Unable to find capability contribution %s in the build model", (Object[])new Object[]{trusted});
                        }
                        for (Repository repo : tc.getRepositories()) {
                            allRepos.add(java.net.URI.create(repo.getLocation()));
                        }
                    }
                    this.trustedContributionRepos = allRepos.toArray(new java.net.URI[allRepos.size()]);
                } else {
                    this.trustedContributionRepos = new java.net.URI[0];
                }
                Buckminster bucky = Buckminster.getDefault();
                PackageAdmin packageAdmin = (PackageAdmin)bucky.getService(PackageAdmin.class);
                try {
                    try {
                        Builder.stopBundle(packageAdmin, BUNDLE_EXEMPLARY_SETUP);
                        Builder.stopBundle(packageAdmin, CORE_BUNDLE);
                        String p2DataArea = new File(this.buildRoot, "p2").toString();
                        System.setProperty(PROP_P2_DATA_AREA, p2DataArea);
                        System.setProperty(PROP_P2_PROFILE, PROFILE_ID);
                        if (!Builder.startEarly(packageAdmin, BUNDLE_ECF_FS_PROVIDER)) {
                            throw BuckminsterException.fromMessage((String)"Missing bundle %s", (Object[])new Object[]{BUNDLE_ECF_FS_PROVIDER});
                        }
                        if (!Builder.startEarly(packageAdmin, CORE_BUNDLE)) {
                            throw BuckminsterException.fromMessage((String)"Missing bundle %s", (Object[])new Object[]{CORE_BUNDLE});
                        }
                        if (!Builder.startEarly(packageAdmin, BUNDLE_EXEMPLARY_SETUP)) {
                            throw BuckminsterException.fromMessage((String)"Missing bundle %s", (Object[])new Object[]{BUNDLE_EXEMPLARY_SETUP});
                        }
                        if (!Builder.startEarly(packageAdmin, BUNDLE_UPDATESITE)) {
                            throw BuckminsterException.fromMessage((String)"Missing bundle %s", (Object[])new Object[]{BUNDLE_UPDATESITE});
                        }
                        IProfile profile = null;
                        IProfileRegistry profileRegistry = (IProfileRegistry)bucky.getService(IProfileRegistry.class);
                        if (this.update) {
                            profile = profileRegistry.getProfile(PROFILE_ID);
                        }
                        if (profile == null) {
                            String instArea = this.buildRoot.toString();
                            HashMap<String, String> props = new HashMap<String, String>();
                            props.put("org.eclipse.equinox.p2.flavor", "tooling");
                            props.put("org.eclipse.equinox.p2.name", this.build.getLabel());
                            props.put("org.eclipse.equinox.p2.description", String.format("Default profile during %s build", this.build.getLabel()));
                            props.put("org.eclipse.equinox.p2.cache", instArea);
                            props.put("org.eclipse.equinox.p2.installFolder", instArea);
                            profile = profileRegistry.addProfile(PROFILE_ID, props);
                        }
                        bucky.ungetService((Object)profileRegistry);
                    }
                    catch (BundleException e) {
                        throw BuckminsterException.wrap((Throwable)e);
                    }
                }
                finally {
                    bucky.ungetService((Object)packageAdmin);
                }
                this.runTemplateExpansion(this.resourceSet, "build2page::Main", new File(this.buildRoot, "index.php"));
                this.runTemplateExpansion(this.resourceSet, "build2xml::Main", new File(this.buildRoot, "index.xml"));
                this.runCompositeGenerator(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)70));
                if (this.brandingBuild) {
                    this.runBrandingFeatureBuild(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                }
                this.runCategoriesRepoGenerator(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
                this.runRepositoryVerifier(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                if (!this.verifyOnly) {
                    this.runMirroring(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900));
                }
            }
            catch (Throwable e) {
                Buckminster.getLogger().error(e, "Build failed! Exception was %s", new Object[]{Builder.getExceptionMessages(e)});
                if (e instanceof Error) {
                    throw (Error)e;
                }
                Integer n = 1;
                monitor.done();
                return n;
            }
        }
        finally {
            monitor.done();
        }
        return IApplication.EXIT_OK;
    }

    private void runBrandingFeatureBuild(IProgressMonitor monitor) throws CoreException {
        if (this.brandingFeature == null) {
            return;
        }
        BrandingFeatureCompiler brandingFeatureCompiler = new BrandingFeatureCompiler(this, this.brandingFeature);
        brandingFeatureCompiler.run(monitor);
    }

    private void runCategoriesRepoGenerator(IProgressMonitor monitor) throws CoreException {
        CategoryRepoGenerator extraGenerator = new CategoryRepoGenerator(this);
        extraGenerator.run(monitor);
    }

    private void runCompositeGenerator(IProgressMonitor monitor) throws CoreException {
        CompositeRepoGenerator repoGenerator = new CompositeRepoGenerator(this);
        repoGenerator.run(monitor);
    }

    private void runMirroring(IProgressMonitor monitor) throws CoreException {
        MirrorGenerator mirrorGenerator = new MirrorGenerator(this);
        mirrorGenerator.run(monitor);
    }

    private void runRepositoryVerifier(IProgressMonitor monitor) throws CoreException {
        RepositoryVerifier ipt = new RepositoryVerifier(this);
        ipt.run(monitor);
    }

    private void runTemplateExpansion(ResourceSet rs, String name, File outFile) throws IOException {
        XpandFacade xf = new XpandFacade(rs);
        xf.addLocation("platform:/plugin/org.eclipse.buckminster.galileo.builder/templates/");
        xf.addLocation("platform:/plugin/org.eclipse.amalgam.releng.builder/transformations/");
        String result = xf.xpand(name, (Object)this.build, new Object[0]);
        FileOutputStream os = new FileOutputStream(outFile);
        os.write(result.getBytes());
        os.close();
    }

    private void runTransformation(Date now) throws CoreException {
        try {
            this.resourceSet = new ResourceSetImpl();
            this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            BuildPackage.eINSTANCE.eClass();
            URI fileURI = URI.createFileURI((String)this.buildModelLocation.getAbsolutePath());
            Resource resource = this.resourceSet.getResource(fileURI, true);
            EList content = resource.getContents();
            if (content.size() != 1) {
                throw BuckminsterException.fromMessage((String)"ECore Resource did not contain one resource. It had %d", (Object[])new Object[]{content.size()});
            }
            this.build = (Build)content.get(0);
            Diagnostic diag = Diagnostician.INSTANCE.validate((EObject)this.build);
            if (diag.getSeverity() == 4) {
                Logger log = Buckminster.getLogger();
                for (Diagnostic childDiag : diag.getChildren()) {
                    log.error(childDiag.getMessage(), new Object[0]);
                }
                throw BuckminsterException.fromMessage((String)"Build model validation failed: %s", (Object[])new Object[]{diag.getMessage()});
            }
            this.build.setDate(DATE_FORMAT.format(now));
            this.build.setTime(TIME_FORMAT.format(now));
            if (this.buildRoot == null) {
                this.buildRoot = new File(PROPERTY_REPLACER.replaceProperties(this.build.getBuildRoot()));
            }
            if (!this.update && this.buildRoot.exists()) {
                IPath wsPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                if (Path.fromOSString((String)this.buildRoot.getAbsolutePath()).isPrefixOf(wsPath)) {
                    Builder.deleteAllButWorkspace(this.buildRoot, wsPath);
                } else {
                    FileUtils.deleteAll((File)this.buildRoot);
                    if (this.buildRoot.exists()) {
                        throw BuckminsterException.fromMessage((String)"Failed to delete folder %s", (Object[])new Object[]{this.buildRoot.getAbsolutePath()});
                    }
                }
            }
            this.buildRoot.mkdirs();
            if (!this.buildRoot.exists()) {
                throw BuckminsterException.fromMessage((String)"Failed to create folder %s", (Object[])new Object[]{this.buildRoot});
            }
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public void sendEmail(Contribution contrib, List<String> errors) {
        boolean useMock;
        boolean bl = useMock = this.mockEmailTo != null;
        if (!this.production && !useMock && this.sendmail) {
            return;
        }
        Logger log = Buckminster.getLogger();
        try {
            ArrayList<EmailAddress> recipients;
            EmailAddress buildMaster = new EmailAddress(this.buildMasterEmail, this.buildMasterName);
            EmailAddress emailFromAddr = this.emailFrom != null ? new EmailAddress(this.emailFrom, this.emailFromName) : buildMaster;
            ArrayList<EmailAddress> toList = new ArrayList<EmailAddress>();
            if (contrib == null) {
                toList.add(buildMaster);
            } else {
                for (Contact contact : contrib.getContacts()) {
                    toList.add(new EmailAddress(contact.getEmail(), contact.getName()));
                }
            }
            StringBuilder msgBld = new StringBuilder();
            msgBld.append("The following error");
            if (errors.size() > 1) {
                msgBld.append('s');
            }
            msgBld.append(" occured when building ");
            msgBld.append(this.buildLabel);
            msgBld.append(":\n\n");
            for (String error : errors) {
                msgBld.append(error);
                msgBld.append("\n\n");
            }
            if (this.logURL != null) {
                msgBld.append("Check the log file for more information: ");
                msgBld.append(this.logURL);
                msgBld.append('\n');
            }
            if (useMock) {
                msgBld.append("\nThis is a mock mail. Real recipients would have been:\n");
                for (EmailAddress to : toList) {
                    msgBld.append("  ");
                    msgBld.append(to);
                    msgBld.append('\n');
                }
            }
            String msgContent = msgBld.toString();
            if (this.subjectPrefix == null) {
                this.subjectPrefix = this.buildLabel;
            }
            String subject = String.format("[%s] Failed for build %s", this.subjectPrefix, this.buildID);
            msgBld.setLength(0);
            msgBld.append("Sending email to: ");
            for (EmailAddress to : toList) {
                msgBld.append(to);
                msgBld.append(',');
            }
            msgBld.append(buildMaster);
            if (useMock) {
                msgBld.append(" *** Using mock: ");
                if (this.mockEmailTo != null) {
                    msgBld.append(this.mockEmailTo);
                    if (this.mockEmailCC != null) {
                        msgBld.append(',');
                        msgBld.append(this.mockEmailTo);
                    }
                } else {
                    msgBld.append(this.mockEmailCC);
                }
                msgBld.append(" ***");
            }
            log.info(msgBld.toString(), new Object[0]);
            log.info("From: %s", new Object[]{emailFromAddr});
            log.info("Subject: %s", new Object[]{subject});
            log.info("Message content: %s", new Object[]{msgContent});
            EmailAddress ccRecipient = null;
            if (useMock) {
                recipients = this.mockRecipients();
                ccRecipient = this.mockCCRecipient();
            } else {
                recipients = toList;
                if (contrib != null) {
                    ccRecipient = buildMaster;
                }
            }
            Builder.send(this.smtpHost, this.smtpPort, emailFromAddr, recipients, ccRecipient, subject, msgContent);
        }
        catch (IOException e) {
            log.error((Throwable)e, "Failed to send email: %s", new Object[]{e.getMessage()});
        }
    }

    public void setBrandingBuild(boolean brandingBuild) {
        this.brandingBuild = brandingBuild;
    }

    public void setBrandingContribution(String brandingContribution) {
        this.brandingContribution = brandingContribution;
    }

    public void setBuildID(String buildId) {
        this.buildID = buildId;
    }

    public void setBuildModelLocation(File buildModelLocation) {
        this.buildModelLocation = buildModelLocation;
    }

    public void setBuildRoot(File buildRoot) {
        this.buildRoot = buildRoot;
    }

    public void setCategoriesRepo(java.net.URI categoriesRepo) {
        this.categoriesRepo = categoriesRepo;
    }

    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    public void setEmailFromName(String emailFromName) {
        this.emailFromName = emailFromName;
    }

    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    public void setLogURL(String logURL) {
        this.logURL = logURL;
    }

    public void setMirrorReferences(boolean mirrorReferences) {
        this.mirrorReferences = mirrorReferences;
    }

    public void setMockEmailCC(String mockEmailCc) {
        this.mockEmailCC = mockEmailCc;
    }

    public void setMockEmailTo(String mockEmailTo) {
        this.mockEmailTo = mockEmailTo;
    }

    public void setPackedStrategy(PackedStrategy packedStrategy) {
        this.packedStrategy = packedStrategy;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    public void setReferenceExcludePattern(String pattern) {
        this.referenceExcludePattern = (pattern = Trivial.trim((String)pattern)) == null ? null : Pattern.compile(pattern);
    }

    public void setReferenceIncludePattern(String pattern) {
        this.referenceIncludePattern = (pattern = Trivial.trim((String)pattern)) == null ? null : Pattern.compile(pattern);
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setSubjectPrefix(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    public void setTrustedContributions(String trustedContribs) {
        int idx = trustedContribs.indexOf(44);
        while (idx > 0) {
            String tc = Trivial.trim((String)trustedContribs.substring(0, idx));
            if (tc != null) {
                this.trustedContributions.add(tc);
            }
            trustedContribs = trustedContribs.substring(idx + 1);
            idx = trustedContribs.indexOf(44);
        }
        if ((trustedContribs = Trivial.trim((String)trustedContribs)) != null) {
            this.trustedContributions.add(trustedContribs);
        }
    }

    public void setTrustedUnits(Set<IInstallableUnit> trustedUnits) {
        this.trustedUnits = trustedUnits;
    }

    public void setUnitsToAggregate(Set<IInstallableUnit> unitsToAggregate) {
        this.unitsToAggregate = unitsToAggregate;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setVerifyOnly(boolean verifyOnly) {
        this.verifyOnly = verifyOnly;
    }

    public boolean skipFeature(Feature feature, List<String> errors) {
        if (feature.getRepo() == null) {
            if (this.brandingFeature != feature && errors != null) {
                String error = String.format("Skipping feature %s/%s since it has no repository", feature.getId(), feature.getVersion());
                errors.add(error);
                Buckminster.getLogger().error(error, new Object[0]);
            }
            return true;
        }
        return Builder.isCapabilitiesFeature(feature);
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        Logger.setEclipseLoggerLevelThreshold((int)8);
        Logger log = Buckminster.getLogger();
        StringBuilder msgBld = new StringBuilder();
        msgBld.append("Running with arguments:");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            msgBld.append(LINE_SEPARATOR);
            msgBld.append("  '");
            msgBld.append(arg);
            msgBld.append('\'');
            ++n2;
        }
        String msg = msgBld.toString();
        try {
            this.parseCommandLineArgs(args);
            Logger.setConsoleLevelThreshold((int)this.logLevel);
            log.debug(msg, new Object[0]);
        }
        catch (Exception e) {
            log.info(msg, new Object[0]);
            return 1;
        }
        return this.run((IProgressMonitor)new NullProgressMonitor());
    }

    public void stop() {
    }

    private void verifyContributions() throws CoreException {
        Element masterBuild;
        DocumentBuilder docBld;
        java.net.URI buildModelFolderURI = this.buildModelLocation.getParentFile().toURI();
        DocumentBuilderFactory docBldFact = DocumentBuilderFactory.newInstance();
        try {
            docBld = docBldFact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            Document doc = docBld.parse(this.buildModelLocation);
            masterBuild = doc.getDocumentElement();
            this.sendmail = "true".equalsIgnoreCase(masterBuild.getAttribute("sendmail"));
            this.buildLabel = Trivial.trim((String)masterBuild.getAttribute("label"));
        }
        catch (Exception e) {
            String msg = e instanceof SAXParseException ? String.format("Unable to parse file: %s: Error at line %s: %s", this.buildModelLocation, ((SAXParseException)e).getLineNumber(), e.getMessage()) : String.format("Unable to parse file: %s: %s", this.buildModelLocation, e.getMessage());
            throw BuckminsterException.fromMessage((String)msg, (Object[])new Object[0]);
        }
        ArrayList<File> contributionFiles = new ArrayList<File>();
        Node child = masterBuild.getFirstChild();
        while (child != null) {
            block17: {
                Element elem;
                block18: {
                    if (!(child instanceof Element)) break block17;
                    elem = (Element)child;
                    if (!"contributions".equals(elem.getNodeName())) break block18;
                    String attr = Trivial.trim((String)elem.getAttribute("href"));
                    if (attr == null) break block17;
                    if (attr.endsWith("#/")) {
                        attr = attr.substring(0, attr.length() - 2);
                    }
                    java.net.URI uri = buildModelFolderURI.resolve(java.net.URI.create(attr));
                    contributionFiles.add(new File(uri));
                }
                if ("buildmaster".equals(elem.getNodeName())) {
                    this.buildMasterEmail = Trivial.trim((String)elem.getAttribute("email"));
                    this.buildMasterName = Trivial.trim((String)elem.getAttribute("name"));
                }
            }
            child = child.getNextSibling();
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (File buildFile : contributionFiles) {
            try {
                try {
                    docBld.parse(buildFile);
                }
                catch (Exception e) {
                    String msg = e instanceof SAXParseException ? String.format("Unable to parse file: %s: Error at line %s: %s", buildFile, ((SAXParseException)e).getLineNumber(), e.getMessage()) : String.format("Unable to parse file: %s: %s", buildFile, e.getMessage());
                    Buckminster.getLogger().error((Throwable)e, msg, new Object[0]);
                    errors.add(msg);
                    docBld.reset();
                    continue;
                }
            }
            catch (Throwable throwable) {
                docBld.reset();
                throw throwable;
            }
            docBld.reset();
        }
        if (errors.size() > 0) {
            this.sendEmail(null, errors);
            throw BuckminsterException.fromMessage((String)"Not all contributions could be parsed", (Object[])new Object[0]);
        }
    }

    private static class EmailAddress {
        private final String address;
        private final String personal;

        EmailAddress(String address, String personal) {
            this.address = address;
            this.personal = personal;
        }

        public String toString() {
            if (this.personal == null) {
                return this.address;
            }
            return String.valueOf(this.personal) + " <" + this.address + ">";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PackedStrategy {
        COPY,
        VERIFY,
        UNPACK_AS_SIBLING,
        UNPACK,
        SKIP;

    }
}

