/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.galileo.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.amalgam.releng.build.Category;
import org.eclipse.amalgam.releng.build.Contribution;
import org.eclipse.amalgam.releng.build.Feature;
import org.eclipse.buckminster.galileo.builder.Builder;
import org.eclipse.buckminster.pde.tasks.FeatureVersionSuffixGenerator;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoriesAction
extends AbstractPublisherAction {
    private final Builder builder;
    private final IMetadataRepository globalRepo;

    public CategoriesAction(Builder builder, IMetadataRepository globalRepo) {
        this.builder = builder;
        this.globalRepo = globalRepo;
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        HashMap<Category, Set<IInstallableUnit>> categoriesToFeatureIUs = new HashMap<Category, Set<IInstallableUnit>>();
        try {
            for (Contribution contrib : this.builder.getBuild().getContributions()) {
                for (Feature feature : contrib.getFeatures()) {
                    if (this.builder.skipFeature(feature, null)) continue;
                    for (Category category : feature.getCategory()) {
                        if (category == null) continue;
                        IInstallableUnit featureIU = this.getFeatureIU(feature.getId(), feature.getVersion(), publisherInfo, monitor);
                        HashSet<IInstallableUnit> featureIUs = (HashSet<IInstallableUnit>)categoriesToFeatureIUs.get(category);
                        if (featureIUs == null) {
                            featureIUs = new HashSet<IInstallableUnit>();
                            categoriesToFeatureIUs.put(category, featureIUs);
                        }
                        featureIUs.add(featureIU);
                    }
                }
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        this.generateCategoryIUs(categoriesToFeatureIUs, results);
        return Status.OK_STATUS;
    }

    private IInstallableUnit createCategoryIU(Category category, Set<IInstallableUnit> featureIUs, IInstallableUnit parentCategory) {
        MetadataFactory.InstallableUnitDescription cat = new MetadataFactory.InstallableUnitDescription();
        cat.setSingleton(true);
        String categoryId = category.getName();
        FeatureVersionSuffixGenerator vsGen = new FeatureVersionSuffixGenerator();
        ArrayList<VersionedName> featureVNs = new ArrayList<VersionedName>(featureIUs.size());
        for (IInstallableUnit iu : featureIUs) {
            featureVNs.add(new VersionedName(iu.getId(), iu.getVersion()));
        }
        Version categoryVersion = Version.createOSGi((int)0, (int)0, (int)0, (String)vsGen.generateSuffix(featureVNs, Collections.emptyList()));
        cat.setId(categoryId);
        cat.setVersion(categoryVersion);
        cat.setProperty("org.eclipse.equinox.p2.name", category.getLabel());
        cat.setProperty("org.eclipse.equinox.p2.description", category.getDescription());
        ArrayList<IRequiredCapability> reqsConfigurationUnits = new ArrayList<IRequiredCapability>(featureIUs.size());
        for (IInstallableUnit iu : featureIUs) {
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            reqsConfigurationUnits.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (String)iu.getFilter(), (boolean)false, (boolean)false));
        }
        if (parentCategory != null) {
            reqsConfigurationUnits.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)parentCategory.getId(), (VersionRange)VersionRange.emptyRange, (String)parentCategory.getFilter(), (boolean)false, (boolean)false));
        }
        cat.setRequiredCapabilities(reqsConfigurationUnits.toArray(new IRequiredCapability[reqsConfigurationUnits.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability((String)categoryId, (Version)categoryVersion));
        cat.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        cat.setArtifacts(new IArtifactKey[0]);
        cat.setProperty("org.eclipse.equinox.p2.type.category", "true");
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cat);
    }

    private void generateCategoryIUs(Map<Category, Set<IInstallableUnit>> categoriesToFeatures, IPublisherResult result) {
        for (Map.Entry<Category, Set<IInstallableUnit>> entry : categoriesToFeatures.entrySet()) {
            result.addIU(this.createCategoryIU(entry.getKey(), entry.getValue(), null), "non_root");
        }
    }

    private IInstallableUnit getFeatureIU(String name, String versionStr, IPublisherInfo publisherInfo, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String id = String.valueOf(name) + ".feature.group";
        InstallableUnitQuery query = null;
        Collector collector = null;
        Version version = Version.parseVersion((String)versionStr);
        if (version.equals((Object)Version.emptyVersion)) {
            query = new CompositeQuery(new Query[]{new InstallableUnitQuery(id), new LatestIUVersionQuery()});
            collector = new Collector();
        } else {
            query = new InstallableUnitQuery(id, version);
            collector = new Collector(){

                public boolean accept(Object object) {
                    super.accept(object);
                    return false;
                }
            };
        }
        collector = this.globalRepo.query((Query)query, collector, monitor);
        if (collector.size() == 0) {
            collector = publisherInfo.getMetadataRepository().query((Query)query, collector, null);
        }
        if (collector.size() == 0 && publisherInfo.getContextMetadataRepository() != null) {
            collector = publisherInfo.getContextMetadataRepository().query((Query)query, collector, null);
        }
        if (collector.size() == 1) {
            return (IInstallableUnit)collector.iterator().next();
        }
        throw BuckminsterException.fromMessage((String)"Unable to find feature %s/%s using composite repository", (Object[])new Object[]{name, version});
    }
}

