/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.galileo.builder;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.buckminster.galileo.builder.AllContributedCapabilitiesAction;
import org.eclipse.buckminster.galileo.builder.AllContributedContentAction;
import org.eclipse.buckminster.galileo.builder.Builder;
import org.eclipse.buckminster.galileo.builder.BuilderPhase;
import org.eclipse.buckminster.galileo.builder.CategoriesAction;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;

public class CategoryRepoGenerator
extends BuilderPhase {
    public CategoryRepoGenerator(Builder builder) {
        super(builder);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        Logger log = Buckminster.getLogger();
        log.info("Starting generation of categories", new Object[0]);
        long now = System.currentTimeMillis();
        String name = String.valueOf(this.getBuilder().getBuild().getLabel()) + " Categories";
        File globalLocation = new File(this.getBuilder().getBuildRoot(), "interim");
        File location = new File(globalLocation, "categories");
        FileUtils.deleteAll((File)location);
        HashMap properties = new HashMap();
        URI globalLocationURI = this.getBuilder().getGlobalRepoURI();
        URI locationURI = Builder.createURI(location);
        Buckminster bucky = Buckminster.getDefault();
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)bucky.getService(IMetadataRepositoryManager.class);
        IArtifactRepositoryManager arMgr = (IArtifactRepositoryManager)bucky.getService(IArtifactRepositoryManager.class);
        MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
        try {
            mdrMgr.removeRepository(locationURI);
            IMetadataRepository mdr = mdrMgr.createRepository(locationURI, name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            arMgr.removeRepository(locationURI);
            IArtifactRepository ar = arMgr.createRepository(locationURI, String.valueOf(name) + " artifacts", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            CompositeMetadataRepository globalMdr = (CompositeMetadataRepository)mdrMgr.loadRepository(globalLocationURI, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5));
            CompositeArtifactRepository globalAr = (CompositeArtifactRepository)arMgr.loadRepository(globalLocationURI, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5));
            PublisherInfo info = new PublisherInfo();
            info.setArtifactRepository(ar);
            info.setArtifactOptions(3);
            info.setMetadataRepository(mdr);
            Publisher publisher = new Publisher((IPublisherInfo)info);
            IStatus result = publisher.publish(this.createActions(mdr, (IMetadataRepository)globalMdr), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
            if (result.getSeverity() == 4) {
                throw new CoreException(result);
            }
            globalMdr.addChild(mdr.getLocation());
            globalAr.addChild(ar.getLocation());
        }
        finally {
            bucky.ungetService((Object)mdrMgr);
            bucky.ungetService((Object)arMgr);
            MonitorUtils.done((IProgressMonitor)monitor);
        }
        this.getBuilder().setCategoriesRepo(locationURI);
        log.info("Done. Took %d ms", new Object[]{System.currentTimeMillis() - now});
    }

    private IPublisherAction[] createActions(IMetadataRepository mdr, IMetadataRepository globalMdr) {
        return new IPublisherAction[]{new AllContributedCapabilitiesAction(this.getBuilder(), globalMdr, mdr), new AllContributedContentAction(this.getBuilder(), globalMdr, mdr), new CategoriesAction(this.getBuilder(), globalMdr)};
    }
}

