/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.galileo.builder;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.amalgam.releng.build.Build;
import org.eclipse.amalgam.releng.build.Bundle;
import org.eclipse.amalgam.releng.build.Contribution;
import org.eclipse.amalgam.releng.build.Feature;
import org.eclipse.amalgam.releng.build.Product;
import org.eclipse.amalgam.releng.build.Repository;
import org.eclipse.buckminster.galileo.builder.Builder;
import org.eclipse.buckminster.galileo.builder.BuilderPhase;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeRepoGenerator
extends BuilderPhase {
    private static void verifyIUExistence(IMetadataRepositoryManager mdrMgr, Repository repo, String id, String version, List<String> errors) throws CoreException {
        if (repo == null) {
            String msg = String.format("Unable to find %s/%s since its repository definition is missing", id, version);
            errors.add(msg);
            Buckminster.getLogger().error(msg, new Object[0]);
            return;
        }
        URI location = URI.create(repo.getLocation());
        if (Builder.getIU(mdrMgr.loadRepository(location, null), id, version) == null) {
            String msg = String.format("Unable to find %s/%s in repository %s", id, version, repo.getLocation());
            errors.add(msg);
            Buckminster.getLogger().error(msg, new Object[0]);
        }
    }

    public CompositeRepoGenerator(Builder builder) {
        super(builder);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        Logger log = Buckminster.getLogger();
        log.info("Starting generation of composite repository", new Object[0]);
        long now = System.currentTimeMillis();
        String name = String.valueOf(this.getBuilder().getBuild().getLabel()) + " Composite";
        File location = new File(this.getBuilder().getBuildRoot(), "interim");
        FileUtils.deleteAll((File)location);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", Boolean.toString(true));
        URI locationURI = Builder.createURI(location);
        Build buildModel = this.getBuilder().getBuild();
        EList contribs = buildModel.getContributions();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(contribs.size() * 100));
        boolean errorsFound = false;
        Buckminster bucky = Buckminster.getDefault();
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)bucky.getService(IMetadataRepositoryManager.class);
        mdrMgr.removeRepository(locationURI);
        CompositeMetadataRepository mdr = (CompositeMetadataRepository)mdrMgr.createRepository(locationURI, name, "org.eclipse.equinox.p2.metadata.repository.compositeRepository", properties);
        IArtifactRepositoryManager arMgr = (IArtifactRepositoryManager)bucky.getService(IArtifactRepositoryManager.class);
        arMgr.removeRepository(locationURI);
        CompositeArtifactRepository ar = (CompositeArtifactRepository)arMgr.createRepository(locationURI, String.valueOf(name) + " artifacts", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", properties);
        for (Contribution contrib : contribs) {
            IProgressMonitor contribMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100);
            EList repos = contrib.getRepositories();
            MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 200));
            ArrayList<String> errors = new ArrayList<String>();
            for (Repository repo : repos) {
                try {
                    URI childLocation = URI.create(repo.getLocation());
                    log.info("Adding child meta-data repository %s", new Object[]{childLocation});
                    mdrMgr.loadRepository(childLocation, MonitorUtils.subMonitor((IProgressMonitor)contribMonitor, (int)100));
                    mdr.addChild(childLocation);
                    log.info("Adding child artifact repository %s", new Object[]{childLocation});
                    arMgr.loadRepository(childLocation, MonitorUtils.subMonitor((IProgressMonitor)contribMonitor, (int)100));
                    ar.addChild(childLocation);
                }
                catch (Exception e) {
                    String msg = Builder.getExceptionMessages(e);
                    errors.add(msg);
                    log.error((Throwable)e, msg, new Object[0]);
                }
            }
            if (errors.size() == 0) {
                for (Feature feature : contrib.getFeatures()) {
                    if (feature.getRepo() == null && this.getBuilder().getBrandingFeature() == feature) continue;
                    CompositeRepoGenerator.verifyIUExistence(mdrMgr, feature.getRepo(), String.valueOf(feature.getId()) + ".feature.group", feature.getVersion(), errors);
                }
                for (Bundle bundle : contrib.getBundles()) {
                    CompositeRepoGenerator.verifyIUExistence(mdrMgr, bundle.getRepo(), bundle.getId(), bundle.getVersion(), errors);
                }
                for (Product product : contrib.getProducts()) {
                    CompositeRepoGenerator.verifyIUExistence(mdrMgr, product.getRepo(), product.getId(), product.getVersion(), errors);
                }
            }
            MonitorUtils.done((IProgressMonitor)contribMonitor);
            if (errors.isEmpty()) continue;
            this.getBuilder().sendEmail(contrib, errors);
            errorsFound = true;
        }
        bucky.ungetService((Object)mdrMgr);
        bucky.ungetService((Object)arMgr);
        MonitorUtils.done((IProgressMonitor)monitor);
        log.info("Done. Took %d ms", new Object[]{System.currentTimeMillis() - now});
        if (errorsFound) {
            throw BuckminsterException.fromMessage((String)"CompositeRepository generation was not succesful", (Object[])new Object[0]);
        }
    }
}

