/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.galileo.builder;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.amalgam.releng.build.Contribution;
import org.eclipse.amalgam.releng.build.Repository;
import org.eclipse.buckminster.galileo.builder.Builder;
import org.eclipse.buckminster.galileo.builder.BuilderPhase;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.RawMirrorRequest;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.repository.ICompositeRepository;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.RepositoryReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorGenerator
extends BuilderPhase {
    private static final Method LocalMetadataRepository_createRepositoriesSnapshot;
    private IMetadataRepositoryManager mdrMgr = null;
    private IArtifactRepositoryManager arMgr = null;

    static {
        try {
            LocalMetadataRepository_createRepositoriesSnapshot = LocalMetadataRepository.class.getDeclaredMethod("createRepositoriesSnapshot", new Class[0]);
            LocalMetadataRepository_createRepositoriesSnapshot.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static IStatus extractDeeperRootCause(IStatus status) {
        IStatus deeper;
        Throwable t;
        if (status == null) {
            return null;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = ((MultiStatus)status).getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus deeper2 = MirrorGenerator.extractDeeperRootCause(children[i]);
                if (deeper2 != null) {
                    return deeper2;
                }
                ++i;
            }
        }
        if ((t = status.getException()) instanceof CoreException && (deeper = MirrorGenerator.extractDeeperRootCause(((CoreException)t).getStatus())) != null) {
            return deeper;
        }
        return status.getSeverity() == 4 ? status : null;
    }

    private static IStatus extractRootCause(IStatus status) {
        IStatus rootCause = MirrorGenerator.extractDeeperRootCause(status);
        return rootCause == null ? status : rootCause;
    }

    private static List<URI> getCompositeChildren(IRepository repository) {
        return repository instanceof ICompositeRepository ? ((ICompositeRepository)repository).getChildren() : Collections.emptyList();
    }

    private static List<RepositoryReference> getRepositoryReferences(LocalMetadataRepository localMdr) throws CoreException {
        try {
            return (List)LocalMetadataRepository_createRepositoriesSnapshot.invoke((Object)localMdr, new Object[0]);
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    private static void mirror(IArtifactRepository source, IArtifactRepository dest, IArtifactDescriptor sourceDesc, IArtifactDescriptor targetDesc, IProgressMonitor monitor) throws CoreException {
        if (dest.contains(sourceDesc)) {
            return;
        }
        RawMirrorRequest request = new RawMirrorRequest(sourceDesc, targetDesc, dest);
        request.setSourceRepository(source);
        request.perform(monitor);
        IStatus result = request.getResult();
        if (result.getSeverity() == 4 && result.getCode() != 1201) {
            dest.removeDescriptor(sourceDesc);
            result = MirrorGenerator.extractRootCause(result);
            throw BuckminsterException.fromMessage((Throwable)result.getException(), (String)"Unable to mirror artifact %s from repository %s: %s", (Object[])new Object[]{sourceDesc.getArtifactKey(), source.getLocation(), result.getMessage()});
        }
    }

    private static void unpackToSibling(IArtifactRepository target, IArtifactDescriptor optimized, IArtifactDescriptor canonical, boolean verifyOnly, IProgressMonitor monitor) throws CoreException {
        CanonicalizeRequest request = new CanonicalizeRequest(optimized, canonical, target);
        request.perform(monitor);
        IStatus result = request.getResult();
        if (result.getSeverity() != 4 || result.getCode() == 1201) {
            if (verifyOnly) {
                target.removeDescriptor(canonical);
            }
            return;
        }
        result = MirrorGenerator.extractRootCause(result);
        target.removeDescriptor(canonical);
        throw BuckminsterException.fromMessage((Throwable)result.getException(), (String)"Unable to unpack artifact %s in repository %s: %s", (Object[])new Object[]{optimized.getArtifactKey(), target.getLocation(), result.getMessage()});
    }

    public MirrorGenerator(Builder builder) {
        super(builder);
    }

    private List<RepositoryReference> getRepositoryReferences(IMetadataRepository mdr) throws CoreException {
        if (mdr instanceof LocalMetadataRepository) {
            return MirrorGenerator.getRepositoryReferences((LocalMetadataRepository)mdr);
        }
        if (mdr instanceof CompositeMetadataRepository) {
            HashSet<RepositoryReference> compositeRefs = new HashSet<RepositoryReference>();
            for (URI child : MirrorGenerator.getCompositeChildren((IRepository)mdr)) {
                compositeRefs.addAll(this.getRepositoryReferences(this.mdrMgr.loadRepository(child, null)));
            }
            if (compositeRefs.size() > 0) {
                return new ArrayList<RepositoryReference>(compositeRefs);
            }
        }
        return Collections.emptyList();
    }

    private void mirror(IArtifactRepository source, IArtifactRepository dest, Set<IArtifactKey> keysToInstall, List<String> errors, IProgressMonitor monitor) {
        Logger log = Buckminster.getLogger();
        IArtifactKey[] keys = source.getArtifactKeys();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(keys.length * 100));
        IArtifactKey[] iArtifactKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactKey key = iArtifactKeyArray[n2];
            if (keysToInstall.contains(key)) {
                log.info("- mirroring artifact %s", new Object[]{key});
                Builder.PackedStrategy strategy = this.getBuilder().getPackedStrategy();
                if (!"osgi.bundle".equals(key.getClassifier())) {
                    strategy = Builder.PackedStrategy.SKIP;
                }
                try {
                    IArtifactDescriptor[] aDescs = source.getArtifactDescriptors(key);
                    IArtifactDescriptor optimized = null;
                    IArtifactDescriptor canonical = null;
                    IArtifactDescriptor[] iArtifactDescriptorArray = aDescs;
                    int n3 = aDescs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IArtifactDescriptor desc = iArtifactDescriptorArray[n4];
                        if (desc.getProperty("format") == null) {
                            canonical = desc;
                        } else if (ProcessingStepHandler.canProcess((IArtifactDescriptor)desc)) {
                            optimized = desc;
                        }
                        ++n4;
                    }
                    if (optimized == null && canonical == null) {
                        throw BuckminsterException.fromMessage((String)"Found no usable descriptor for artifact %s in repository %s", (Object[])new Object[]{key, dest.getLocation()});
                    }
                    if (optimized == null) {
                        log.debug("    doing copy of canonical artifact", new Object[0]);
                        MirrorGenerator.mirror(source, dest, canonical, canonical, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                    } else {
                        switch (strategy) {
                            case SKIP: {
                                if (canonical == null) {
                                    throw BuckminsterException.fromMessage((String)"No canonical artifact %s found in repository %s", (Object[])new Object[]{key, dest.getLocation()});
                                }
                                log.debug("    doing copy of canonical artifact", new Object[0]);
                                MirrorGenerator.mirror(source, dest, canonical, canonical, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                            }
                            case COPY: {
                                log.debug("    doing copy of optimized artifact", new Object[0]);
                                MirrorGenerator.mirror(source, dest, optimized, optimized, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                                break;
                            }
                            default: {
                                if (canonical == null) {
                                    ArtifactDescriptor ad = new ArtifactDescriptor(key);
                                    ad.setRepository(dest);
                                    canonical = ad;
                                }
                                if (strategy == Builder.PackedStrategy.UNPACK) {
                                    log.debug("    doing copy of optimized artifact into canonical target", new Object[0]);
                                    MirrorGenerator.mirror(source, dest, optimized, canonical, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                                    break;
                                }
                                log.debug("    doing copy of optimized artifact", new Object[0]);
                                MirrorGenerator.mirror(source, dest, optimized, optimized, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)70));
                                boolean isVerify = strategy == Builder.PackedStrategy.VERIFY;
                                log.debug("    unpacking optimized artifact%s", new Object[]{isVerify ? " for verification" : ""});
                                MirrorGenerator.unpackToSibling(dest, optimized, canonical, isVerify, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                                break;
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    errors.add(Builder.getExceptionMessages(e));
                    Buckminster.getLogger().error((Throwable)e, e.getMessage(), new Object[0]);
                }
            }
            ++n2;
        }
        MonitorUtils.done((IProgressMonitor)monitor);
    }

    private void mirror(Query filter, IMetadataRepository source, IMetadataRepository dest, IProgressMonitor monitor) throws CoreException {
        Collector allIUs = source.query(filter, new Collector(), monitor);
        dest.addInstallableUnits((IInstallableUnit[])allIUs.toArray(IInstallableUnit.class));
        Builder builder = this.getBuilder();
        if (builder.isMirrorReferences()) {
            Logger log = Buckminster.getLogger();
            for (RepositoryReference ref : this.getRepositoryReferences(source)) {
                String refType;
                URI location = ref.Location;
                String refKey = location.toString();
                String string = refType = ref.Type == 0 ? "meta-data" : "artifacts";
                if (!builder.isMatchedReference(refKey)) {
                    log.debug("- %s reference %s was ruled out by inclusion/exclusion patterns", new Object[]{refType, refKey});
                    continue;
                }
                if (refKey.endsWith("/site.xml")) {
                    location = URI.create(refKey.substring(0, refKey.length() - 8));
                }
                log.debug("- mirroring %s reference %s", new Object[]{refType, refKey});
                dest.addReference(location, ref.Nickname, ref.Type, 0);
            }
        }
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        Logger log = Buckminster.getLogger();
        log.info("Starting mirror generation", new Object[0]);
        long now = System.currentTimeMillis();
        Builder builder = this.getBuilder();
        File destination = new File(builder.getBuildRoot(), "final");
        URI finalURI = Builder.createURI(destination);
        File aggregateDestination = destination;
        URI aggregateURI = finalURI;
        Buckminster bucky = Buckminster.getDefault();
        this.mdrMgr = (IMetadataRepositoryManager)bucky.getService(IMetadataRepositoryManager.class);
        this.arMgr = (IArtifactRepositoryManager)bucky.getService(IArtifactRepositoryManager.class);
        URI source = builder.getGlobalRepoURI();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
        boolean artifactErrors = false;
        try {
            Object[] objectArray;
            IMetadataRepository child;
            String label;
            HashMap<String, String> properties;
            boolean isUpdate = builder.isUpdate();
            URI[] trustedRepos = builder.getTrustedContributionRepos();
            if (trustedRepos.length > 0) {
                aggregateDestination = new File(destination, "aggregate");
                aggregateURI = Builder.createURI(aggregateDestination);
            }
            IArtifactRepository aggregateAr = null;
            IMetadataRepository finalMdr = null;
            if (!isUpdate) {
                FileUtils.deleteAll((File)destination);
                this.mdrMgr.removeRepository(finalURI);
                this.arMgr.removeRepository(aggregateURI);
                MonitorUtils.worked((IProgressMonitor)monitor, (int)2);
            } else {
                try {
                    aggregateAr = this.arMgr.loadRepository(aggregateURI, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                }
                catch (ProvisionException provisionException) {
                    // empty catch block
                }
                try {
                    finalMdr = this.mdrMgr.loadRepository(finalURI, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                }
                catch (ProvisionException provisionException) {
                    // empty catch block
                }
            }
            URI mirrors = builder.getMirrorsURI(false);
            if (aggregateAr == null) {
                properties = new HashMap<String, String>();
                properties.put("p2.compressed", Boolean.toString(true));
                properties.put("publishPackFilesAsSiblings", Boolean.toString(true));
                if (mirrors != null) {
                    URI artifactMirrors = trustedRepos.length > 0 ? builder.getMirrorsURI(true) : mirrors;
                    properties.put("p2.mirrorsURL", artifactMirrors.toString());
                }
                label = builder.getBuild().getLabel();
                aggregateAr = this.arMgr.createRepository(aggregateURI, String.valueOf(label) + " artifacts", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            }
            if (finalMdr == null) {
                properties = new HashMap();
                properties.put("p2.compressed", Boolean.toString(true));
                if (mirrors != null) {
                    properties.put("p2.mirrorsURL", mirrors.toString());
                }
                label = builder.getBuild().getLabel();
                finalMdr = this.mdrMgr.createRepository(finalURI, label, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            }
            IMetadataRepository sourceMdr = this.mdrMgr.loadRepository(source, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            IArtifactRepository sourceAr = this.arMgr.loadRepository(source, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            final Set<IInstallableUnit> unitsToInstall = builder.getUnitsToAggregate();
            Set<IInstallableUnit> unverifiedRoots = builder.getUnverifiedUnits();
            if (!unverifiedRoots.isEmpty()) {
                PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)sourceMdr, null, true, false, true, false, false);
                IQueryable slice = slicer.slice(unverifiedRoots.toArray(new IInstallableUnit[unverifiedRoots.size()]), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                MatchQuery adder = new MatchQuery(){

                    public boolean isMatch(Object candidate) {
                        unitsToInstall.add((IInstallableUnit)candidate);
                        return false;
                    }
                };
                slice.query((Query)adder, new Collector(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            }
            URI categoryRepo = builder.getCategoriesRepo();
            List<URI> children = MirrorGenerator.getCompositeChildren((IRepository)sourceMdr);
            IProgressMonitor childMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)7);
            MonitorUtils.begin((IProgressMonitor)childMonitor, (int)((trustedRepos.length + children.size()) * 100));
            for (URI childURI : children) {
                if (childURI.equals(categoryRepo)) continue;
                log.info("Mirroring meta-data from from %s", new Object[]{childURI});
                IMetadataRepository child2 = this.mdrMgr.loadRepository(childURI, MonitorUtils.subMonitor((IProgressMonitor)childMonitor, (int)1));
                this.mirror((Query)new IncludesQuery(unitsToInstall), child2, finalMdr, MonitorUtils.subMonitor((IProgressMonitor)childMonitor, (int)99));
            }
            Set<IInstallableUnit> trustedUnits = builder.getTrustedUnits();
            if (trustedUnits.size() > 0) {
                URI[] uRIArray = trustedRepos;
                int n = trustedRepos.length;
                int child2 = 0;
                while (child2 < n) {
                    URI trustedRepo = uRIArray[child2];
                    log.info("Mirroring meta-data from from %s", new Object[]{trustedRepo});
                    child = this.mdrMgr.loadRepository(trustedRepo, MonitorUtils.subMonitor((IProgressMonitor)childMonitor, (int)1));
                    this.mirror((Query)new IncludesQuery(trustedUnits), child, finalMdr, MonitorUtils.subMonitor((IProgressMonitor)childMonitor, (int)99));
                    ++child2;
                }
            }
            childMonitor.done();
            IMetadataRepository categoryRepository = this.mdrMgr.loadRepository(categoryRepo, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            this.mirror((Query)new AllButAllContributedFeature(), categoryRepository, finalMdr, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            log.info("Done mirroring meta-data", new Object[0]);
            HashSet<IArtifactKey> keysToInstall = new HashSet<IArtifactKey>(unitsToInstall.size());
            for (IInstallableUnit iu : unitsToInstall) {
                objectArray = iu.getArtifacts();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IArtifactKey key = objectArray[n2];
                    keysToInstall.add(key);
                    ++n2;
                }
            }
            children = MirrorGenerator.getCompositeChildren((IRepository)sourceAr);
            childMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)88);
            MonitorUtils.begin((IProgressMonitor)childMonitor, (int)(children.size() * 100));
            block11: for (URI childURI : children) {
                if (childURI.equals(categoryRepo)) continue;
                objectArray = trustedRepos;
                int n = trustedRepos.length;
                int n3 = 0;
                while (n3 < n) {
                    IArtifactKey trustedRepo = objectArray[n3];
                    if (childURI.equals(trustedRepo)) continue block11;
                    ++n3;
                }
                log.info("Mirroring artifacts from from %s", new Object[]{childURI});
                child = this.arMgr.loadRepository(childURI, MonitorUtils.subMonitor((IProgressMonitor)childMonitor, (int)1));
                ArrayList<String> errors = new ArrayList<String>();
                this.mirror((IArtifactRepository)child, aggregateAr, keysToInstall, errors, MonitorUtils.subMonitor((IProgressMonitor)childMonitor, (int)99));
                if (errors.size() <= 0) continue;
                artifactErrors = true;
                String childStr = childURI.toString();
                if (!childStr.endsWith("/")) {
                    childStr = String.valueOf(childStr) + "/";
                }
                Contribution repoContributor = null;
                block13: for (Contribution contrib : builder.getBuild().getContributions()) {
                    for (Repository repo : contrib.getRepositories()) {
                        String repoLoc = repo.getLocation();
                        if (!repoLoc.endsWith("/")) {
                            repoLoc = String.valueOf(repoLoc) + "/";
                        }
                        if (!repoLoc.equals(childStr)) continue;
                        repoContributor = contrib;
                        break block13;
                    }
                }
                if (repoContributor == null) continue;
                builder.sendEmail(repoContributor, errors);
            }
            log.info("Done mirroring artifacts", new Object[0]);
            childMonitor.done();
            FileUtils.deleteAll((File)new File(destination, "compositeArtifacts.jar"));
            if (trustedRepos.length > 0) {
                log.info("Building final artifact composite at %s", new Object[]{finalURI});
                HashMap<String, String> properties2 = new HashMap<String, String>();
                properties2.put("p2.compressed", Boolean.toString(true));
                String name = builder.getBuild().getLabel();
                this.arMgr.removeRepository(finalURI);
                CompositeArtifactRepository compositeAr = (CompositeArtifactRepository)this.arMgr.createRepository(finalURI, String.valueOf(name) + " artifacts", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", properties2);
                URI[] uRIArray = trustedRepos;
                int n = trustedRepos.length;
                int n4 = 0;
                while (n4 < n) {
                    URI trustedURI = uRIArray[n4];
                    compositeAr.addChild(trustedURI);
                    ++n4;
                }
                compositeAr.addChild(finalURI.relativize(aggregateURI));
                log.info("Done building final artifact composite", new Object[0]);
            }
        }
        finally {
            bucky.ungetService((Object)this.mdrMgr);
            this.mdrMgr = null;
            bucky.ungetService((Object)this.arMgr);
            this.arMgr = null;
            MonitorUtils.done((IProgressMonitor)monitor);
        }
        log.info("Done. Took %d ms", new Object[]{System.currentTimeMillis() - now});
        if (artifactErrors) {
            throw BuckminsterException.fromMessage((String)"Not all artifacts could be mirrored", (Object[])new Object[0]);
        }
    }

    private static class AllButAllContributedFeature
    extends MatchQuery {
        private AllButAllContributedFeature() {
        }

        public boolean isMatch(Object candidate) {
            return !(candidate instanceof IInstallableUnit) || !"all.contributed.content.feature.group".equals(((IInstallableUnit)candidate).getId());
        }
    }

    private static class CanonicalizeRequest
    extends MirrorRequest {
        private IArtifactDescriptor optimizedDescriptor;
        private IArtifactDescriptor canonicalDescriptor;

        public CanonicalizeRequest(IArtifactDescriptor optimizedDescriptor, IArtifactDescriptor canonicalDescriptor, IArtifactRepository targetRepository) {
            super(canonicalDescriptor.getArtifactKey(), targetRepository, null, null);
            this.optimizedDescriptor = optimizedDescriptor;
            this.canonicalDescriptor = canonicalDescriptor;
            this.setSourceRepository(targetRepository);
        }

        public void perform(IProgressMonitor monitor) {
            this.setResult(this.transfer(this.canonicalDescriptor, this.optimizedDescriptor, monitor));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncludesQuery
    extends MatchQuery {
        private final Set<IInstallableUnit> unitsToInclude;

        public IncludesQuery(Set<IInstallableUnit> unitsToInclude) {
            this.unitsToInclude = unitsToInclude;
        }

        public boolean isMatch(Object candidate) {
            return this.unitsToInclude.contains(candidate);
        }
    }
}

