/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.galileo.builder;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.amalgam.releng.build.ARCH;
import org.eclipse.amalgam.releng.build.Bundle;
import org.eclipse.amalgam.releng.build.Config;
import org.eclipse.amalgam.releng.build.Contribution;
import org.eclipse.amalgam.releng.build.Feature;
import org.eclipse.amalgam.releng.build.OS;
import org.eclipse.amalgam.releng.build.Product;
import org.eclipse.amalgam.releng.build.WS;
import org.eclipse.buckminster.galileo.builder.Builder;
import org.eclipse.buckminster.galileo.builder.BuilderPhase;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryVerifier
extends BuilderPhase {
    private static String configEnvString(Config config) {
        ARCH arch;
        OS os;
        StringBuilder bld = new StringBuilder();
        WS ws = config.getWs();
        if (ws != null) {
            bld.append("osgi.ws=");
            bld.append(ws.getLiteral());
        }
        if ((os = config.getOs()) != null) {
            if (bld.length() > 0) {
                bld.append(',');
            }
            bld.append("osgi.os=");
            bld.append(os.getLiteral());
        }
        if ((arch = config.getArch()) != null) {
            if (bld.length() > 0) {
                bld.append(',');
            }
            bld.append("osgi.arch=");
            bld.append(arch.getLiteral());
        }
        return bld.toString();
    }

    private static String configNameString(Config config) {
        ARCH arch;
        OS os;
        StringBuilder bld = new StringBuilder();
        WS ws = config.getWs();
        if (ws != null) {
            bld.append(ws.getLiteral());
        }
        if ((os = config.getOs()) != null) {
            if (bld.length() > 0) {
                bld.append('.');
            }
            bld.append(os.getLiteral());
        }
        if ((arch = config.getArch()) != null) {
            if (bld.length() > 0) {
                bld.append('.');
            }
            bld.append(arch.getLiteral());
        }
        return bld.toString();
    }

    private static ProvisioningContext createContext(URI site) {
        URI[] repoLocations = new URI[]{site};
        ProvisioningContext context = new ProvisioningContext(repoLocations);
        context.setArtifactRepositories(repoLocations);
        return context;
    }

    private static Set<Explanation> getExplanations(RequestStatus requestStatus) {
        return requestStatus.getExplanations();
    }

    private static IInstallableUnit[] getRootIUs(URI site, IProfile profile, String iuName, Version version, IProgressMonitor monitor) throws CoreException {
        InstallableUnitQuery query = new InstallableUnitQuery(iuName, new VersionRange(version, true, version, true));
        Collector roots = ProvisioningHelper.getInstallableUnits((URI)site, (Query)new CompositeQuery(new Query[]{query, new LatestIUVersionQuery()}), (Collector)new Collector(), (IProgressMonitor)monitor);
        if (roots.size() <= 0) {
            roots = profile.query((Query)query, roots, (IProgressMonitor)new NullProgressMonitor());
        }
        if (roots.size() <= 0) {
            throw BuckminsterException.fromMessage((String)"Feature %s not found", (Object[])new Object[]{iuName});
        }
        return (IInstallableUnit[])roots.toArray(IInstallableUnit.class);
    }

    public RepositoryVerifier(Builder builder) {
        super(builder);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        Logger log = Buckminster.getLogger();
        log.info("Starting planner verification", new Object[0]);
        long now = System.currentTimeMillis();
        String profilePrefix = "GalileoTest_";
        final HashSet<IInstallableUnit> unitsToAggregate = new HashSet<IInstallableUnit>();
        final HashSet<IInstallableUnit> trustedUnits = new HashSet<IInstallableUnit>();
        EList configs = this.getBuilder().getBuild().getConfigs();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)(configs.size() * 100));
        Buckminster bucky = Buckminster.getDefault();
        IProfileRegistry profileRegistry = (IProfileRegistry)bucky.getService(IProfileRegistry.class);
        IPlanner planner = (IPlanner)bucky.getService(IPlanner.class);
        boolean update = this.getBuilder().isUpdate();
        URI repoLocation = this.getBuilder().getGlobalRepoURI();
        try {
            try {
                for (Config config : configs) {
                    Operand[] ops;
                    String configName = RepositoryVerifier.configNameString(config);
                    String profileId = String.valueOf(profilePrefix) + configName;
                    log.info("Verifying config: %s", new Object[]{configName});
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("org.eclipse.equinox.p2.flavor", "tooling");
                    props.put("org.eclipse.equinox.p2.environments", RepositoryVerifier.configEnvString(config));
                    props.put("org.eclipse.update.install.features", "true");
                    IProfile profile = null;
                    if (update) {
                        profile = profileRegistry.getProfile(profileId);
                    }
                    if (profile == null) {
                        profile = profileRegistry.addProfile(profileId, props);
                    }
                    IInstallableUnit[] rootArr = RepositoryVerifier.getRootIUs(repoLocation, profile, "all.contributed.content.feature.group", Builder.ALL_CONTRIBUTED_CONTENT_VERSION, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
                    ProfileChangeRequest request = new ProfileChangeRequest(profile);
                    IInstallableUnit[] iInstallableUnitArray = rootArr;
                    int n = rootArr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IInstallableUnit rootIU = iInstallableUnitArray[n2];
                        request.setInstallableUnitProfileProperty(rootIU, "org.eclipse.equinox.p2.type.root", (Object)Boolean.TRUE.toString());
                        ++n2;
                    }
                    request.addInstallableUnits(rootArr);
                    ProvisioningPlan plan = planner.getProvisioningPlan(request, RepositoryVerifier.createContext(repoLocation), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                    IStatus status = plan.getStatus();
                    if (status.getSeverity() == 4) {
                        this.sendEmails(plan.getRequestStatus());
                        log.info("Done. Took %d ms", new Object[]{System.currentTimeMillis() - now});
                        throw new CoreException(status);
                    }
                    Operand[] operandArray = ops = plan.getOperands();
                    int n3 = ops.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        InstallableUnitOperand iuOp;
                        IInstallableUnit iu;
                        Operand op = operandArray[n4];
                        if (op instanceof InstallableUnitOperand && (iu = (iuOp = (InstallableUnitOperand)op).second()) != null && !"all.contributed.content.feature.group".equals(iu.getId())) {
                            unitsToAggregate.add(iu);
                        }
                        ++n4;
                    }
                }
            }
            catch (RuntimeException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
            bucky.ungetService((Object)profileRegistry);
            bucky.ungetService((Object)planner);
        }
        log.info("Done. Took %d ms", new Object[]{System.currentTimeMillis() - now});
        log.info("Found %d units to install", new Object[]{unitsToAggregate.size()});
        URI[] trustedURIs = this.getBuilder().getTrustedContributionRepos();
        if (trustedURIs.length > 0 && unitsToAggregate.size() > 0) {
            log.info("Pruning using trusted contributed repositories", new Object[]{unitsToAggregate.size()});
            IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)bucky.getService(IMetadataRepositoryManager.class);
            URI[] uRIArray = trustedURIs;
            int n = trustedURIs.length;
            int n5 = 0;
            while (n5 < n) {
                URI trusted = uRIArray[n5];
                IMetadataRepository trustedRepo = mdrMgr.loadRepository(trusted, null);
                trustedRepo.query((Query)new MatchQuery(){

                    public boolean isMatch(Object candidate) {
                        if (unitsToAggregate.remove(candidate)) {
                            trustedUnits.add((IInstallableUnit)candidate);
                        }
                        return false;
                    }
                }, new Collector(), null);
                ++n5;
            }
            bucky.ungetService((Object)mdrMgr);
            log.info("%d units remain after pruning", new Object[]{unitsToAggregate.size()});
        }
        this.getBuilder().setUnitsToAggregate(unitsToAggregate);
        this.getBuilder().setTrustedUnits(trustedUnits);
    }

    private boolean addLeafmostContributions(Set<Explanation> explanations, Map<String, Contribution> contributions, IRequiredCapability prq) {
        boolean contribsFound = false;
        for (Explanation explanation : explanations) {
            IRequiredCapability crq;
            IInstallableUnit iu;
            if (explanation instanceof Explanation.Singleton) {
                if (contribsFound) continue;
                IInstallableUnit[] iInstallableUnitArray = ((Explanation.Singleton)explanation).ius;
                int n = ((Explanation.Singleton)explanation).ius.length;
                int n2 = 0;
                while (n2 < n) {
                    iu = iInstallableUnitArray[n2];
                    IProvidedCapability[] iProvidedCapabilityArray = iu.getProvidedCapabilities();
                    int n3 = iProvidedCapabilityArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Contribution contrib;
                        IProvidedCapability pc = iProvidedCapabilityArray[n4];
                        if (pc.satisfies(prq) && (contrib = this.findContribution(iu.getId())) != null) {
                            contribsFound = true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                continue;
            }
            if (explanation instanceof Explanation.HardRequirement) {
                Explanation.HardRequirement hrq = (Explanation.HardRequirement)explanation;
                iu = hrq.iu;
                crq = hrq.req;
            } else {
                if (!(explanation instanceof Explanation.MissingIU)) continue;
                Explanation.MissingIU miu = (Explanation.MissingIU)explanation;
                iu = miu.iu;
                crq = miu.req;
            }
            IProvidedCapability[] iProvidedCapabilityArray = iu.getProvidedCapabilities();
            int n = iProvidedCapabilityArray.length;
            int n5 = 0;
            while (n5 < n) {
                IProvidedCapability pc = iProvidedCapabilityArray[n5];
                if (pc.satisfies(prq)) {
                    if (this.addLeafmostContributions(explanations, contributions, crq)) {
                        contribsFound = true;
                    } else {
                        Contribution contrib = this.findContribution(iu, crq);
                        if (contrib != null) {
                            contributions.put(contrib.getLabel(), contrib);
                        }
                    }
                }
                ++n5;
            }
        }
        return contribsFound;
    }

    private Contribution findContribution(IInstallableUnit iu, IRequiredCapability rq) {
        Contribution contrib = null;
        if ("osgi.bundle".equals(rq.getNamespace()) || "org.eclipse.equinox.p2.iu".equals(rq.getNamespace())) {
            contrib = this.findContribution(rq.getName());
        }
        if (contrib == null) {
            contrib = this.findContribution(iu.getId());
        }
        return contrib;
    }

    private Contribution findContribution(String componentId) {
        for (Contribution contrib : this.getBuilder().getBuild().getContributions()) {
            for (Feature feature : contrib.getFeatures()) {
                String fullId = String.valueOf(feature.getId()) + ".feature.group";
                if (!fullId.equals(componentId)) continue;
                return contrib;
            }
            for (Bundle bundle : contrib.getBundles()) {
                if (!bundle.getId().equals(componentId)) continue;
                return contrib;
            }
            for (Product product : contrib.getProducts()) {
                if (!product.getId().equals(componentId)) continue;
                return contrib;
            }
        }
        return null;
    }

    private void sendEmails(RequestStatus requestStatus) {
        Builder builder = this.getBuilder();
        if (!builder.getBuild().isSendmail()) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        Set<Explanation> explanations = RepositoryVerifier.getExplanations(requestStatus);
        HashMap<String, Contribution> contribs = new HashMap<String, Contribution>();
        for (Explanation explanation : explanations) {
            Contribution contrib;
            IRequiredCapability crq;
            IInstallableUnit iu;
            errors.add(explanation.toString());
            if (explanation instanceof Explanation.Singleton) {
                IInstallableUnit[] iInstallableUnitArray = ((Explanation.Singleton)explanation).ius;
                int n = ((Explanation.Singleton)explanation).ius.length;
                int n2 = 0;
                while (n2 < n) {
                    iu = iInstallableUnitArray[n2];
                    Contribution contrib2 = this.findContribution(iu.getId());
                    if (contrib2 != null) {
                        contribs.put(contrib2.getLabel(), contrib2);
                    }
                    ++n2;
                }
                continue;
            }
            if (explanation instanceof Explanation.HardRequirement) {
                Explanation.HardRequirement hrq = (Explanation.HardRequirement)explanation;
                iu = hrq.iu;
                crq = hrq.req;
            } else {
                if (!(explanation instanceof Explanation.MissingIU)) continue;
                Explanation.MissingIU miu = (Explanation.MissingIU)explanation;
                iu = miu.iu;
                crq = miu.req;
            }
            if (this.addLeafmostContributions(explanations, contribs, crq) || (contrib = this.findContribution(iu, crq)) == null) continue;
            contribs.put(contrib.getLabel(), contrib);
        }
        if (contribs.isEmpty()) {
            builder.sendEmail(null, errors);
        } else {
            for (Contribution contrib : contribs.values()) {
                builder.sendEmail(contrib, errors);
            }
        }
    }
}

