/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jarprocessor;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.jar.JarFile;
import java.util.jar.Pack200;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.eclipse.buckminster.jarprocessor.IConstants;
import org.eclipse.buckminster.jarprocessor.JarInfo;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RecursivePack200
implements IConstants {
    private final List<String> m_defaultArgs;
    static final Pattern EFFORT_PATTERN = Pattern.compile("^-(?:E|-effort=)([0-9])$");
    private static final Pattern s_stripDebugPattern = Pattern.compile("^-(?:G|-strip-debug)$");
    private static final Pattern s_noKeepFileOrderPattern = Pattern.compile("^-(?:O|-no-keep-file-order)$");
    private static final Pattern s_keepFileOrderPattern = Pattern.compile("^--keep-file-order$");
    private static final Pattern s_segmentLimitPattern = Pattern.compile("^-(?:S|-segment-limit=)([0-9]+)$");
    private static final Pattern s_deflateHintPattern = Pattern.compile("^-(?:H|-deflate-hint=)(true|false|keep)$");
    private static final Pattern s_modificationTimePatter = Pattern.compile("^-(?:m|-modification-time=)(latest|keep)$");
    private static final Pattern s_passFilePatter = Pattern.compile("^-(?:P|-pass-file=)(.+)$");

    static ZipEntry createEntry(ZipEntry original) {
        ZipEntry copy = RecursivePack200.createEntry(original, original.getName());
        copy.setExtra(original.getExtra());
        return copy;
    }

    static ZipEntry createEntry(ZipEntry original, String name) {
        ZipEntry copy = new ZipEntry(name);
        copy.setComment(original.getComment());
        copy.setTime(original.getTime());
        return copy;
    }

    RecursivePack200(List<String> defaultArgs) {
        this.m_defaultArgs = defaultArgs == null || defaultArgs.isEmpty() ? Collections.emptyList() : new ArrayList<String>(defaultArgs);
    }

    Pack200.Packer getPacker(JarInfo jarInfo) {
        int passFileSuffix = 1;
        ArrayList<String> args = new ArrayList<String>();
        jarInfo.appendArgs(args);
        args.addAll(this.m_defaultArgs);
        HashSet<String> propsAdded = new HashSet<String>();
        Pack200.Packer packer = Pack200.newPacker();
        SortedMap properties = packer.properties();
        if (!jarInfo.hasClasses()) {
            propsAdded.add("pack.effort");
            properties.put("pack.effort", "0");
        }
        for (String arg : args) {
            Matcher m = EFFORT_PATTERN.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.effort")) continue;
                properties.put("pack.effort", m.group(1));
                continue;
            }
            m = s_segmentLimitPattern.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.segment.limit")) continue;
                properties.put("pack.segment.limit", m.group(1));
                continue;
            }
            m = s_noKeepFileOrderPattern.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.keep.file.order")) continue;
                properties.put("pack.keep.file.order", "false");
                continue;
            }
            m = s_keepFileOrderPattern.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.keep.file.order")) continue;
                properties.put("pack.keep.file.order", "true");
                continue;
            }
            m = s_stripDebugPattern.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("strip.debug")) continue;
                properties.put("pack.code.attribute.LineNumberTable", "strip");
                properties.put("pack.code.attribute.LocalVariableTable", "strip");
                properties.put("pack.class.attribute.SourceFile", "strip");
                continue;
            }
            m = s_deflateHintPattern.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.deflate.hint")) continue;
                properties.put("pack.deflate.hint", m.group(1));
                continue;
            }
            m = s_modificationTimePatter.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.modification.time")) continue;
                properties.put("pack.modification.time", m.group(1));
                continue;
            }
            m = s_passFilePatter.matcher(arg);
            if (!m.matches()) continue;
            IPath path = Path.fromOSString((String)m.group(1));
            properties.put("pack.pass.file.." + passFileSuffix++, path.toPortableString());
        }
        return packer;
    }

    Pack200.Unpacker getUnpacker() {
        return Pack200.newUnpacker();
    }

    void pack(JarInfo jarInfo, InputStream in, OutputStream out) throws IOException {
        File temp = null;
        try {
            temp = File.createTempFile("conditionFile", ".jar");
            FileOutputStream tempOut = null;
            try {
                tempOut = new FileOutputStream(temp);
                IOUtils.copy((InputStream)in, (OutputStream)tempOut, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable throwable) {
                IOUtils.close(tempOut);
                throw throwable;
            }
            IOUtils.close((Closeable)tempOut);
            Pack200.Packer packer = this.getPacker(jarInfo);
            packer.pack(new JarFile(temp), out);
            out.flush();
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    static class NonClosingInputStream
    extends FilterInputStream {
        public NonClosingInputStream(InputStream wrapped) throws IOException {
            super(wrapped);
        }

        public void close() throws IOException {
        }
    }
}

