/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.opml.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.buckminster.opml.IBody;
import org.eclipse.buckminster.opml.IOutline;
import org.eclipse.buckminster.opml.builder.BodyBuilder;
import org.eclipse.buckminster.opml.builder.OutlineBuilder;
import org.eclipse.buckminster.opml.model.Outline;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Body
extends AbstractSaxableElement
implements IBody {
    public static final String TAG = "body";
    private final List<Outline> m_outlines;

    public Body(BodyBuilder bodyBuilder) {
        List<OutlineBuilder> outlineBuilders = bodyBuilder.getOutlineBuilders();
        int top = outlineBuilders.size();
        if (top == 0) {
            this.m_outlines = Collections.emptyList();
        } else {
            ArrayList<Outline> outlines = new ArrayList<Outline>(top);
            for (OutlineBuilder outlineBuilder : outlineBuilders) {
                outlines.add(new Outline(outlineBuilder));
            }
            this.m_outlines = Utils.createUnmodifiableList(outlines);
        }
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public List<? extends IOutline> getOutlines() {
        return this.m_outlines;
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        for (Outline outline : this.m_outlines) {
            outline.toSax(handler, namespace, prefix, outline.getDefaultTag());
        }
    }
}

