/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.opml.parser;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.eclipse.buckminster.opml.Messages;
import org.eclipse.buckminster.opml.builder.HeadBuilder;
import org.eclipse.buckminster.opml.model.Head;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.StringElementHandler;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class HeadHandler
extends ChildHandler {
    public static final String TAG = "head";
    private final HeadBuilder m_head;
    private final StringHandler m_stringHandler = new StringHandler();

    HeadHandler(AbstractHandler parent, HeadBuilder head) {
        super(parent);
        this.m_head = head;
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        return this.m_stringHandler;
    }

    class StringHandler
    extends StringElementHandler {
        StringHandler() {
            super((AbstractHandler)HeadHandler.this);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            String name;
            super.endElement(uri, localName, qName);
            String string = name = localName == null || localName.length() == 0 ? qName : localName;
            if ("dateCreated".equals(name)) {
                HeadHandler.this.m_head.setDateCreated(this.getDate(name));
            } else if ("dateModified".equals(name)) {
                HeadHandler.this.m_head.setDateModified(this.getDate(name));
            } else if ("docs".equals(name)) {
                HeadHandler.this.m_head.setDocs(this.getURI(name));
            } else if ("expansionState".equals(name)) {
                HeadHandler.this.m_head.setExpansionState(this.getIntList(name));
            } else if ("ownerEmail".equals(name)) {
                HeadHandler.this.m_head.setOwnerEmail(this.getString());
            } else if ("ownerId".equals(name)) {
                HeadHandler.this.m_head.setOwnerId(this.getURI(name));
            } else if ("ownerName".equals(name)) {
                HeadHandler.this.m_head.setOwnerName(this.getString());
            } else if ("title".equals(name)) {
                HeadHandler.this.m_head.setTitle(this.getString());
            } else if ("vertScrollState".equals(name)) {
                HeadHandler.this.m_head.setVertScrollState(this.getInt(name));
            } else if ("windowBottom".equals(name)) {
                HeadHandler.this.m_head.setWindowBottom(this.getInt(name));
            } else if ("windowLeft".equals(name)) {
                HeadHandler.this.m_head.setWindowLeft(this.getInt(name));
            } else if ("windowRight".equals(name)) {
                HeadHandler.this.m_head.setWindowRight(this.getInt(name));
            } else if ("windowTop".equals(name)) {
                HeadHandler.this.m_head.setWindowTop(this.getInt(name));
            }
        }

        private Date getDate(String localName) throws SAXException {
            try {
                return Head.RFC_822_FORMAT.parse(this.getString());
            }
            catch (ParseException e) {
                throw new SAXParseException(NLS.bind((String)Messages.element_0_does_not_represent_a_valid_RFC822_formatted_date, (Object)localName), this.getDocumentLocator());
            }
        }

        private int getInt(String localName) throws SAXException {
            try {
                return Integer.parseInt(this.getString());
            }
            catch (NumberFormatException e) {
                throw new SAXParseException(NLS.bind((String)Messages.element_0_does_not_represent_a_valid_integer, (Object)localName), this.getDocumentLocator());
            }
        }

        private int[] getIntList(String localName) throws SAXException {
            try {
                StringTokenizer tokens = new StringTokenizer(this.getString(), ",");
                ArrayList<String> values = new ArrayList<String>();
                while (tokens.hasMoreTokens()) {
                    values.add(tokens.nextToken().trim());
                }
                int idx = values.size();
                int[] intList = new int[idx];
                while (--idx >= 0) {
                    intList[idx] = Integer.parseInt((String)values.get(idx));
                }
                return intList;
            }
            catch (NumberFormatException e) {
                throw new SAXParseException(NLS.bind((String)Messages.element_0_does_not_represent_a_valid_list_of_integers, (Object)localName), this.getDocumentLocator());
            }
        }

        private String getString() {
            return new String(this.getBuffer(), 0, this.getLengthAndReset());
        }

        private URI getURI(String localName) throws SAXException {
            try {
                return new URI(this.getString());
            }
            catch (URISyntaxException e) {
                throw new SAXParseException(NLS.bind((String)Messages.element_0_does_not_represent_a_valid_URI, (Object)localName), this.getDocumentLocator());
            }
        }
    }
}

