/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.io.IOException;
import java.io.OutputStream;

public class MultiTeeOutputStream
extends OutputStream {
    private final OutputStream[] m_streams;

    public MultiTeeOutputStream(OutputStream[] streams) {
        this.m_streams = streams;
    }

    public void close() throws IOException {
        IOException closeException = null;
        int idx = this.m_streams.length;
        while (--idx >= 0) {
            try {
                this.m_streams[idx].close();
            }
            catch (IOException ioe) {
                if (closeException != null) continue;
                closeException = ioe;
            }
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    public void flush() throws IOException {
        int idx = this.m_streams.length;
        while (--idx >= 0) {
            this.m_streams[idx].flush();
        }
    }

    public void write(byte[] b) throws IOException {
        int idx = this.m_streams.length;
        while (--idx >= 0) {
            this.m_streams[idx].write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int idx = this.m_streams.length;
        while (--idx >= 0) {
            this.m_streams[idx].write(b, off, len);
        }
    }

    public void write(int b) throws IOException {
        int idx = this.m_streams.length;
        while (--idx >= 0) {
            this.m_streams[idx].write(b);
        }
    }
}

