/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class URLUtils {
    public static URL appendPath(URL url, IPath path) {
        if (path == null || path.segmentCount() == 0) {
            return url;
        }
        try {
            String urlPath;
            URI u = url.toURI();
            path = path.setDevice(null);
            if (path.isAbsolute()) {
                urlPath = path.toPortableString();
            } else {
                urlPath = u.getPath();
                if (urlPath == null || urlPath.length() == 0) {
                    urlPath = path.makeAbsolute().toPortableString();
                } else {
                    StringBuilder bld = new StringBuilder();
                    bld.append(urlPath);
                    if (!urlPath.endsWith("/")) {
                        bld.append('/');
                    }
                    bld.append(path.toPortableString());
                    urlPath = bld.toString();
                }
            }
            url = new URI(u.getScheme(), u.getAuthority(), urlPath, u.getQuery(), u.getFragment()).toURL();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    private static void appendQueryItem(StringBuilder query, String item) {
        int top = item.length();
        int idx = 0;
        while (idx < top) {
            char c = item.charAt(idx);
            if (c == '&') {
                query.append(c);
            }
            query.append(c);
            ++idx;
        }
    }

    public static URL appendTrailingSlash(URL url) {
        if (!url.getPath().endsWith("/")) {
            try {
                URI u = url.toURI();
                url = new URI(u.getScheme(), u.getAuthority(), String.valueOf(u.getPath()) + '/', u.getQuery(), u.getFragment()).toURL();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] decodeToQueryPairs(String query) {
        if (query == null || query.length() == 0) {
            return Trivial.EMPTY_STRING_ARRAY;
        }
        pairs = query.split("(?<!&)&(?!&)");
        idx = pairs.length;
        if (idx != 0) ** GOTO lbl8
        return Trivial.EMPTY_STRING_ARRAY;
lbl-1000:
        // 1 sources

        {
            pairs[idx] = pairs[idx].replace("&&", "&");
lbl8:
            // 2 sources

            ** while (--idx >= 0)
        }
lbl9:
        // 1 sources

        return pairs;
    }

    public static String encodeFromQueryPairs(List<String> pairs) {
        if (pairs == null || pairs.size() == 0) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        for (String pair : pairs) {
            if (query.length() > 0) {
                query.append('&');
            }
            URLUtils.appendQueryItem(query, pair);
        }
        return query.toString();
    }

    public static String encodeFromQueryPairs(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (query.length() > 0) {
                query.append('&');
            }
            URLUtils.appendQueryItem(query, entry.getKey());
            query.append('=');
            URLUtils.appendQueryItem(query, entry.getValue());
        }
        return query.toString();
    }

    public static URI getParentURI(URI uri) {
        if (uri == null) {
            return uri;
        }
        IPath uriPath = Path.fromPortableString((String)uri.getPath());
        if (uriPath.segmentCount() == 0) {
            return null;
        }
        uriPath = uriPath.removeLastSegments(1).addTrailingSeparator();
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uriPath.toPortableString(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static URL getParentURL(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return URLUtils.getParentURI(url.toURI()).toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static boolean isLocalURL(URL url) {
        String proto = url.getProtocol();
        if (proto.equals("jar") || proto.equals("reference")) {
            String spec = url.getFile();
            int sepIdx = spec.indexOf(58);
            if (sepIdx == -1) {
                return false;
            }
            proto = spec.substring(0, sepIdx);
        }
        return "file".equals(proto) || "platform".equals(proto) || proto.startsWith("bundle");
    }

    public static URI normalizeToURI(String pathOrURI, boolean asFolder) throws CoreException {
        String scheme;
        URI uri;
        char c;
        if (pathOrURI == null || pathOrURI.length() == 0) {
            return null;
        }
        if ((pathOrURI = pathOrURI.replace('\\', '/')).length() > 1 && pathOrURI.charAt(1) == ':' && ((c = pathOrURI.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            pathOrURI = "file:/" + pathOrURI;
        }
        try {
            uri = new URI(pathOrURI);
        }
        catch (URISyntaxException e) {
            if (pathOrURI.indexOf(32) < 0) {
                throw BuckminsterException.wrap(e);
            }
            try {
                uri = new URI(pathOrURI.replaceAll("\\s", "%20"));
            }
            catch (URISyntaxException e2) {
                throw BuckminsterException.wrap(e2);
            }
        }
        boolean change = false;
        String path = uri.getPath();
        if (asFolder && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
            change = true;
        }
        if ((scheme = uri.getScheme()) == null) {
            scheme = "file";
            change = true;
        }
        try {
            if (change) {
                uri = new URI(scheme, uri.getAuthority(), path, uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap(e);
        }
    }

    public static URL normalizeToURL(String surl) throws MalformedURLException {
        if (surl == null) {
            return null;
        }
        try {
            return new URL(surl);
        }
        catch (MalformedURLException e) {
            if (surl.indexOf(32) > 0) {
                try {
                    return new URL(surl.replaceAll("\\s", "%20"));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            try {
                return new File(surl).toURI().toURL();
            }
            catch (MalformedURLException me2) {
                throw e;
            }
        }
    }

    public static Map<String, String> queryAsParameters(String query) {
        if (query == null) {
            return Collections.emptyMap();
        }
        String[] pairs = URLUtils.decodeToQueryPairs(query);
        int top = pairs.length;
        if (top == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> p = new HashMap<String, String>(top);
        while (--top >= 0) {
            String[] kv = pairs[top].split("=", 2);
            p.put(kv[0], kv[1]);
        }
        return p;
    }

    public static URL resolveURL(URL contextURL, String url) {
        if (url == null) {
            return null;
        }
        try {
            if (contextURL == null) {
                return URLUtils.normalizeToURL(url);
            }
            return new URL(contextURL, url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

