/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.sax;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.buckminster.sax.TopHandler;
import org.eclipse.buckminster.sax.UnrecognizedElementException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class ChildHandler
extends AbstractHandler {
    private AbstractHandler m_parentHandler;

    protected ChildHandler(AbstractHandler parentHandler) {
        this.m_parentHandler = parentHandler;
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        throw new UnrecognizedElementException(this.getTAG(), localName, this.getDocumentLocator());
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.popHandler();
        AbstractHandler parent = this.getParentHandler();
        if (parent instanceof ChildPoppedListener) {
            ((ChildPoppedListener)((Object)parent)).childPopped(this);
        }
    }

    public final AbstractHandler getParentHandler() {
        return this.m_parentHandler;
    }

    public String getPrefixMapping(String prefix) {
        String uri = super.getPrefixMapping(prefix);
        return uri == null ? this.getParentHandler().getPrefixMapping(prefix) : uri;
    }

    public String getTAG() {
        try {
            Field idField = this.getClass().getDeclaredField("TAG");
            int mods = idField.getModifiers();
            if (!idField.isAccessible()) {
                idField.setAccessible(true);
            }
            return Modifier.isStatic(mods) ? (String)idField.get(null) : null;
        }
        catch (NoSuchFieldException e) {
            return this.getClass() + "(lacks TAG field)";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public final TopHandler getTopHandler() {
        return this.m_parentHandler.getTopHandler();
    }

    public void handleAttributes(Attributes attributes) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (localName.length() == 0) {
            localName = qName;
        }
        if (uri.length() == 0) {
            uri = null;
        }
        this.pushHandler(this.createHandler(uri, localName, attrs), attrs);
    }

    protected final Locator getDocumentLocator() {
        return this.m_parentHandler.getDocumentLocator();
    }

    protected final void popHandler() {
        this.getTopHandler().popHandler();
    }

    protected final void pushHandler(ChildHandler handler, Attributes attrs) throws SAXException {
        this.getTopHandler().pushHandler(handler, attrs);
    }
}

