/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.sax;

import java.util.Stack;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.UnrecognizedElementException;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class TopHandler
extends AbstractHandler {
    private Locator m_documentLocator;
    private XMLReader m_reader;
    private final Stack<ContentHandler> m_handlerStack = new Stack();

    protected TopHandler(XMLReader parent) {
        this.m_reader = parent;
        parent.setContentHandler(this);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.popHandler();
    }

    public final AbstractHandler getCurrentHandler() {
        return (AbstractHandler)this.m_reader.getContentHandler();
    }

    public String getEncoding() {
        return Utils.getEncoding(this.m_documentLocator);
    }

    public String getTAG() {
        return "root";
    }

    public final TopHandler getTopHandler() {
        return this;
    }

    public void popFilter() {
        if (this.m_reader instanceof XMLFilterImpl) {
            XMLFilterImpl filter = (XMLFilterImpl)this.m_reader;
            this.m_reader = filter.getParent();
            this.m_reader.setContentHandler(filter.getContentHandler());
            filter.setParent(null);
            filter.setContentHandler(null);
        }
    }

    public void pushFilter(XMLFilterImpl filter) {
        filter.setContentHandler(this.m_reader.getContentHandler());
        this.m_reader.setContentHandler(filter);
        filter.setParent(this.m_reader);
        this.m_reader = filter;
    }

    public final void setDocumentLocator(Locator locator) {
        this.m_documentLocator = locator;
    }

    public final void setEntityResolver(EntityResolver resolver) {
        this.m_reader.setEntityResolver(resolver);
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.m_reader.setErrorHandler(errorHandler);
    }

    public final void setNamespaceAware(boolean flag) {
        try {
            this.m_reader.setFeature("http://xml.org/sax/features/namespaces", flag);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        throw new UnrecognizedElementException("root", qName, this.getDocumentLocator());
    }

    protected final Locator getDocumentLocator() {
        return this.m_documentLocator;
    }

    protected final XMLReader getXMLReader() {
        return this.m_reader;
    }

    protected final void popHandler() {
        this.setHandler(this.m_handlerStack.pop());
    }

    protected final void pushHandler(ChildHandler handler, Attributes attrs) throws SAXException {
        this.m_handlerStack.push(this.m_reader.getContentHandler());
        this.setHandler(handler);
        handler.handleAttributes(attrs);
    }

    private void setHandler(ContentHandler handler) {
        this.m_reader.setContentHandler(handler);
        if (handler instanceof LexicalHandler) {
            try {
                this.m_reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    protected class SAXParserWrapper
    implements ContentHandler {
        protected SAXParserWrapper() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().characters(ch, start, length);
        }

        public void endDocument() throws SAXException {
            TopHandler.this.m_reader.getContentHandler().endDocument();
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().endElement(uri, localName, qName);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().endPrefixMapping(prefix);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().processingInstruction(target, data);
        }

        public void setDocumentLocator(Locator locator) {
            TopHandler.this.m_reader.getContentHandler().setDocumentLocator(locator);
        }

        public void skippedEntity(String name) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().skippedEntity(name);
        }

        public void startDocument() throws SAXException {
            TopHandler.this.m_reader.getContentHandler().startDocument();
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().startElement(uri, localName, qName, atts);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            TopHandler.this.m_reader.getContentHandler().startPrefixMapping(prefix, uri);
        }
    }
}

