/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IGroup;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.Group;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupBuilder
extends TopLevelAttributeBuilder
implements IGroup {
    private final ArrayList<PrerequisiteBuilder> prerequisites = new ArrayList();
    private IPath rebase;

    public static int indexOfPrerequisite(List<? extends IPrerequisite> prerequisites, String prerequisiteKey) {
        int idx = prerequisites.size();
        while (--idx >= 0) {
            if (!prerequisites.get(idx).toString().equals(prerequisiteKey)) continue;
            return idx;
        }
        return -1;
    }

    GroupBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
    }

    @Override
    public PrerequisiteBuilder addPrerequisite(PrerequisiteBuilder prerequisite) throws PrerequisiteAlreadyDefinedException {
        String key = prerequisite.toString();
        if (GroupBuilder.indexOfPrerequisite(this.prerequisites, key) >= 0) {
            throw new PrerequisiteAlreadyDefinedException(this.getCSpecName(), this.getName(), key);
        }
        this.prerequisites.add(prerequisite);
        return prerequisite;
    }

    public void addSelfRequirement() throws PrerequisiteAlreadyDefinedException {
        this.addLocalPrerequisite("buckminster.component.self");
    }

    @Override
    public void clear() {
        super.clear();
        this.prerequisites.clear();
        this.rebase = null;
    }

    @Override
    public Group createAttribute() {
        return new Group(this);
    }

    @Override
    public AttributeBuilder getAttributeBuilder(CSpecBuilder specBuilder) {
        return specBuilder == this.getCSpecBuilder() ? this : new GroupBuilder(specBuilder);
    }

    public PrerequisiteBuilder getPrerequisite(String prerequisteName) {
        int idx = GroupBuilder.indexOfPrerequisite(this.prerequisites, prerequisteName);
        return idx < 0 ? null : this.prerequisites.get(idx);
    }

    public List<Prerequisite> getPrerequisiteList() {
        int top;
        int n = top = this.prerequisites == null ? 0 : this.prerequisites.size();
        if (top == 0) {
            return Collections.emptyList();
        }
        ArrayList<Prerequisite> bld = new ArrayList<Prerequisite>(top);
        int idx = 0;
        while (idx < top) {
            bld.add(this.prerequisites.get(idx).createPrerequisite());
            ++idx;
        }
        return bld;
    }

    @Override
    public IPath getPrerequisiteRebase() {
        return this.rebase;
    }

    public List<PrerequisiteBuilder> getPrerequisites() {
        return this.prerequisites;
    }

    @Override
    public void initFrom(IAttribute attribute) {
        IGroup group = (IGroup)attribute;
        super.initFrom(group);
        for (IPrerequisite iPrerequisite : group.getPrerequisites()) {
            PrerequisiteBuilder pb = this.createPrerequisiteBuilder();
            pb.initFrom(iPrerequisite);
            this.prerequisites.add(pb);
        }
        this.rebase = group.getPrerequisiteRebase();
    }

    @Override
    public void removePrerequisite(String prerequisteName) {
        int idx = GroupBuilder.indexOfPrerequisite(this.prerequisites, prerequisteName);
        if (idx >= 0) {
            this.prerequisites.remove(idx);
        }
    }

    public void setPrerequisiteRebase(IPath rebase) {
        this.rebase = rebase == null ? null : rebase.addTrailingSeparator();
    }

    void finalWrapUp(List<ComponentRequestBuilder> dependencies) {
        for (PrerequisiteBuilder pq : this.prerequisites) {
            pq.finalWrapUp(dependencies);
        }
    }
}

